
/**
 *  Classe Javascript pour l'affichage d'une carte interactive présentatn les points présentés sur une liste Bridge statique
 *  v 1.0 - 02/02/2023
 *  V 1.1 - 15.05.2023 : ajout de la gestion d'un marker actif par défaut (attribute data-dnc-active="1" sur la vignette)
 */

function BridgeSimpleListMapLoader(listIidentifier, mapsIdentifier) {

    this.listContainerId = listIidentifier
    this.mapsDivId = mapsIdentifier

    // Objet carte et options
    this.mapService = null;
    this.mapOptions = {
        markerIcon: '',
        activeMarkerIcon: '',
    };
    this.iconOptions = null;

    // Eviter d'initialiser plusieurs fois
    this.initDone = false;
    this.markercmpt = 0;
    // Pour ne pas charger plusieurs fois les points
    this.pointsAddedToMap = false;

    this.displayMap = function() {
        var self = this

        if (!this.listContainerId || typeof this.listContainerId !== 'string') {
            return false;
        }
        if (!this.mapsDivId || typeof this.mapsDivId !== 'string') {
            return false;
        }
        var testDiv = document.getElementById(this.mapsDivId);
        var testDiv2 = document.getElementById(this.listContainerId);
        if(testDiv == undefined || testDiv == undefined) {
            return false;
        }

        this.mapService = new dncLeafletServices(this.mapsDivId);
        this.mapService.mapoptions = this.mapOptions;

        this.refreshMap();
        if (this.iconOptions !== null) {
            this.mapService.defaultIconOptions = this.iconOptions;
        }
        this.mapService.init();
        // this.mapService.switchToWordpress();
        // this.mapService.disabledMouseWheel();
        // Pour ne pas charger plusieurs fois les points
        this.pointsAddedToMap = false;

        // On ne recharge les points que si la carte est visible
        if(jQuery('#' + this.mapsDivId).is(":visible")) {
            self.mapService.delallmarkers();
            setTimeout(function() {
                self.addPointsToMap();
            }, 200);
        }
        jQuery(window).resize(function () {
            self.refreshMap();
        });
        // Clic sur le bouton de passage en mode carte : on passe sur l'onglet carte de la liste puis on ouvre en plein écran
        jQuery('#' + this.mapsDivId + ' .bridge-map-toggle-fullscreen').click(function (e) {
            e.preventDefault();
            if (self.mapService) {
                self.mapService.delallmarkers();
                setTimeout(function() {
                    self.addPointsToMap();
                }, 200);
                // }
                // On passe la carte en plein écran
                self.mapService.setZoom(14);
                setTimeout(function () {
                    self.mapService.fitboundstomarkers();
                    self.refreshMap();
                    self.mapService.toggleFullScreen();
                }, 250);
            }
        });
    }

    this.addHighlightedMarker = function (lat, lon, id, kml) {
        if(!id) {
            id = 'highlight'
        }
        this.mapService.addmarker(
            id,
            lat,
            lon,
            id,
            this.mapOptions.activeMarkerIcon,
            this.mapOptions.activeMarkerIcon,
            null,
            null,
            kml,
            null,
            null,
            { forceZIndex: 0,  zIndex: 0 ,  zIndexOffset: 0 }
        );
    };

    this.activateMarker = function(id, toggl, animate, iconOptions) {
        self.mapService.activatemarker(id, toggl, animate, iconOptions)
    };

    this.refreshMap = function() {
        var self = this;
        var size = jQuery('#' + self.mapsDivId).width();
        jQuery('#' + self.mapsDivId).css({
            position: 'relative',
            width: (size + 1) + 'px',
        });
    }

    this.addPointsToMap = function() {
        var self = this;
        // On signale que l'init des points est faite
        self.pointsAddedToMap = true;

        jQuery(document).find('#' + self.listContainerId + ' article.ficheproduit').each(function() {
            let productCode = jQuery(this).attr('data-dnc-produit');
            let lat = jQuery(this).attr('data-dnc-lat');
            let lon = jQuery(this).attr('data-dnc-lon');
            let name = jQuery(this).attr('data-dnc-name');
            let active = jQuery(this).attr('data-dnc-active');
            var popupcontent = "";
            /* var onclickf = function(mapositionId) {
                window.mapCoupledService.openinfomarker(mapositionId);
            }; */
            if(productCode != '' && lat != '' && lon !== '' && name !== '') {
                // Ici on construit le contenu du popup
                popupcontent = jQuery(this).html(); // '<a class="uk-button uk-button-primary" href="' + link + '" style="font-size:11px">' + name + '</a>';
                self.mapService.addmarker(
                    productCode,
                    lat,
                    lon,
                    name,
                    self.mapOptions.markerIcon,
                    self.mapOptions.activeMarkerIcon,
                    popupcontent,
                    null,
                    null);

                // Pour activer par défaut un marker on ajoute l'attribute data-dnc-active="1" sur le conteneur
                if (active === '1') {
                    self.mapService.activatemarker(productCode, true, false);
                }
            }


        });
        // Ici on ajuste le Zoom aux points affichés
        setTimeout(function() {
            self.mapService.fitboundstomarkers();
        },500);
    }

}
