<?php

namespace Drupal\pylot_bridge\Services;

use Bridge\Weblibs\BridgeRequestServiceInterface;


class BridgeRequestServiceDrupal implements BridgeRequestServiceInterface
{
    public function cachedFileGetContent($url, $use_include_path = false, $options = null, $cacheTimeMinutes = 120) {

        $context = null;
        if(!empty($options)) {
            $context = stream_context_create($options);
        }
        $hash = hash('md5', $url);
        $cacheKey = 'bridge_request_' . $hash;

		$data = $this->getCachedData($cacheKey);
		if($data === false || empty($data)) {
			$raw = @file_get_contents($url, $use_include_path, $context);
			// Pas de mise en cache si pas de données récupérées (erreur)
			if($raw !== false) {
				$this->storeCachedData($cacheKey, $raw);
			}
			return $raw;
		} else {
			return $data;
		}
        return false;
    }

	public function get($paramName, $default = null)
	{
        $param = $default;
        if(isset($_REQUEST[$paramName])) {
            $param = $_REQUEST[$paramName];
        }
		return $param;
	}

	public function getUrlLastModifiedTimestamp($fileUrl) {
		$headers = @get_headers($fileUrl);
		$lmText = '';
		if(isset($headers['Last-Modified']) && !empty($headers['Last-Modified'])) {
			$lmText = $headers['Last-Modified'];
		} elseif(is_array($headers) && count($headers) > 0) {
			foreach($headers as $idx => $header) {
				if(strpos($header, 'Last-Modified:') !== false) {
					$lmText = trim(substr($header, 14));
				}
			}
		}
		$lmDate = new \DateTime();
		if(!empty($lmText)) {
			$lmDate = new \DateTime($lmText);
		}
		if($lmDate === false) {
			$lmDate = new \DateTime();
		}

		$lmTs = $lmDate->format('U');
		return $lmTs;
	}

	public function getHashFromRequestParameters() {
		return $this->getHashFromObjectOrArray($_REQUEST);
	}

	public function getHashFromObjectOrArray($objectOrArray = null) {
		$hash = '';
		if(isset($objectOrArray) && (is_object($objectOrArray) || is_array($objectOrArray))) {
			$hash = hash('md5', json_encode($objectOrArray));
		}
		return $hash;
	}

	public function getCachedData($cacheKey, $cacheTimeMinutes = 60 * 24 * 30) {
		$ret = null;

		// Pas de cache pour les utilisateurs connectés => on ne cache que pour les visiteurs
		$is_connected = false;
        $testCache = \Drupal::cache()->get($cacheKey);

		if(\Drupal::currentUser()->isAuthenticated())
		{
			$is_connected = true;
		}
		if(!$is_connected && $testCache !== false)
		{
			if (isset($testCache->data) && !empty($testCache->data))
			{
				return $testCache->data;
			}
		}
		return $ret;
	}

	public function storeCachedData($cacheKey, $data) {
        \Drupal::cache()->set($cacheKey, $data);
	}

}


