<?php

namespace Drupal\qr_block\Plugin\qr_block;

use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\Url;
use Drupal\qr_block\QRUrlServicePluginInterface;

/**
 * QR service plugin implementation.
 *
 * @QRUrlServicePlugin(
 *   id = "gchart",
 *   label = "Google Chart API"
 * )
 *
 * Format example:
 *  https://chart.apis.google.com/chart?cht=qr&chs=300x300&chl=DATA&chld=H|0
 */
class GoogleChartAPI extends PluginBase implements QRUrlServicePluginInterface {

  /**
   * Service API URL.
   *
   * @var string
   */
  protected $url = 'https://api.qrserver.com/v1/create-qr-code';

  /**
   * QR URL query params.
   *
   * @var array
   *  Array of params.
   */
  protected $urlQueryParams = [
    'cht' => 'qr',
    'chld' => 'H|0',
  ];

  /**
   * {@inheritdoc}
   */
  public function getUrl() {
    return Url::fromUri($this->url, [
      'query' => $this->getUrlQueryParams(),
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public function getUrlQueryParams() {
    return $this->urlQueryParams += [
      'data' => $this->configuration['data'],
      'size' => "{$this->configuration['image_width']}x{$this->configuration['image_height']}",
    ];
  }

}
