## INTRODUCTION
The **QR Generator** module lets you create and manage QR codes directly in Drupal, with built-in redirection management — acting as your own QR code hosting platform.  
It now also supports **offline, self-contained QR codes** that work without an internet connection when scanned.  

## THIRD-PARTY LIBRARIES
- [endroid/qr-code](https://packagist.org/packages/endroid/qr-code) — QR code generation.  
- [setasign/fpdf](https://packagist.org/packages/setasign/fpdf) — PDF export support.  

## REQUIREMENTS
- PHP ^8.3  
- Drupal Core ^10 || ^11  

## DEPENDENCIES
- **rest** (Drupal core module)  
- **endroid/qr-code** (3rd-party)  
- **setasign/fpdf** (3rd-party)  

## FEATURES
- Generate and export QR codes in multiple formats: **PNG**, **SVG**, and **PDF**.  
- **Offline QR codes**: Create stand-alone QR codes with embedded data, no host needed.  
- **Online redirect QR codes**: Link to a Drupal-managed URL with optional expiry.  
- Export form available at: `/admin/qr-code/export/{entityId}` – quickly generate QR codes for specific entities.  
- Optional expiration date to control QR code validity and access.  

## INSTALLATION
1. Install required libraries:  
   ```bash
   composer require endroid/qr-code
   composer require setasign/fpdf:^1.8
   ```
2. Enable the **QR Generator** module in Drupal.  
3. Clear caches.  

## USAGE
### For Online QR Codes (with redirection)
1. Go to **Content → QR Codes**.  
2. Click **Add QR code**.  
3. Fill in the redirect URL and optional expiry date.  
4. From `/admin/content/qr-code`, click **Export** on your desired QR code.  
5. Select size, margin, and format.  
6. Submit the form to download the QR code.  

### For Offline QR Codes (self-contained)
1. Go to **Content → QR Codes**.  
1. Click **Generate Offline QR Code** form (provided by the module).  
2. Enter the full URL or data to embed directly in the QR code.  
3. Choose size, margin, and format.  
4. Download the generated QR code — no host or internet needed for scanning.  

## MAINTAINERS
- **Lalyo Boyadzhiev** ([l.boyadzhiev](https://www.drupal.org/u/lboyadzhiev))  
