<?php

declare(strict_types=1);

namespace Drupal\qr_generator\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the qr code entity edit forms.
 */
final class QRCodeForm extends ContentEntityForm
{

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state): int
  {
    $result = parent::save($form, $form_state);

    $message_args = ['%label' => $this->entity->toLink()->toString()];
    $logger_args = [
      '%label' => $this->entity->label(),
      'link' => $this->entity->toLink($this->t('View'))->toString(),
    ];

    if ($form_state->getValue('field_expires')[0]['value'] === null) {
      $this->entity->field_expires = null;
      $this->entity->save();
    }


    switch ($result) {
      case SAVED_NEW:
        $this->messenger()->addStatus($this->t('New qr code %label has been created.', $message_args));
        $this->logger('qr_generator')->notice('New qr code %label has been created.', $logger_args);
        break;

      case SAVED_UPDATED:
        $this->messenger()->addStatus($this->t('The qr code %label has been updated.', $message_args));
        $this->logger('qr_generator')->notice('The qr code %label has been updated.', $logger_args);
        break;

      default:
        throw new \LogicException('Could not save the entity.');
    }

    $form_state->setRedirectUrl($this->entity->toUrl());

    return $result;
  }
}
