CONTENTS OF THIS FILE
---------------------

* Introduction
* Installation
* Recommended modules
* Configuration
* Troubleshooting
* Maintainers

INTRODUCTION
------------

Query Auth Params module allows you to protect specific pages on your Drupal
site by requiring query parameters for access. Pages without the correct query
parameters will be redirected to a specified URL or the front page.

**Key Features:**
* Protect pages with custom query parameters
* Supports both system paths (/node/203) and path aliases (/mathematics)
* Flexible access control (Always, Once, or Time-based)
* Custom redirect URLs
* Drupal 9, 10, and 11 compatible

* For a full description of the module, visit the project page:
   <https://drupal.org/project/query_auth_params>

* To submit bug reports and feature suggestions, or to track changes:
   <https://drupal.org/project/issues/query_auth_params>

RECOMMENDED MODULES
-------------------

* No extra module is required.

INSTALLATION
------------

* Install as usual, see
   <https://www.drupal.org/docs/8/extending-drupal-8/installing-contributed-modules-find-import-enable-configure-drupal-8> for further
   information.

CONFIGURATION
-------------

* Navigate to /admin/config/development/query_auth_params
* Add pages you want to protect along with their query parameters

**Example Configuration:**
- Restrict URL: /node/203 (or /mathematics - either works!)
- Param Name: access
- Param Value: secret123
- Access Settings: Always (or Once, or From Datetime onwards)
- Redirect URL: / (optional)

**Path Alias Support:**
The module automatically protects both the system path and its alias.
If you protect /node/203, both /node/203 and /mathematics will require
the query parameter. Similarly, if you configure /mathematics, both URLs
will be protected.

**How it works:**
- Configure: /node/203 with param=secret
- Result: Both /node/203 and /mathematics require ?param=secret

**Access Examples:**
- Allowed: /node/203?access=secret123
- Allowed: /mathematics?access=secret123
- Redirected: /node/203 (without params)
- Redirected: /mathematics (without params)

For detailed technical information, see PATH_ALIAS_IMPLEMENTATION_FINAL.md



MAINTAINERS
-----------

Current maintainers:

* Nikitas Michalakis (<https://drupal.org/user/410290>)
