<?php

/**
 * @file
 * Hooks provided by the Queue Processor module.
 */

declare(strict_types=1);

/**
 * Implements hook_queue_processor_queues_alter().
 *
 * Allows modules to alter queue configurations before processing.
 *
 * @param array $queues
 *   Array of queue configurations. Each item contains:
 *   - id: Queue machine name
 *   - enabled: Boolean enabled status
 *   - priority: Integer priority (0-100, lower = higher priority)
 *   - time_limit: Integer seconds (0 = use remaining global time)
 */
function hook_queue_processor_queues_alter(array &$queues): void {
  // Example: Boost email queue priority during business hours.
  foreach ($queues as &$queue) {
    if ($queue['id'] === 'email_queue' && date('H') >= 9 && date('H') <= 17) {
      $queue['priority'] = max(0, $queue['priority'] - 20);
    }
  }
}
