<?php

namespace Drupal\queue_ui;

/**
 * Utility class for encoding/decoding values for the URL.
 */
class UrlSafeBase64 {

  /**
   * Encode a string as a URL-safe base64 value.
   *
   * @param string $value
   *   The value to encode.
   *
   * @return string
   *   The encoded string.
   *
   * @see https://www.rfc-editor.org/rfc/rfc4648
   */
  public static function encode(string $value): string {
    return str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($value));
  }

  /**
   * Decode a URL-safe base64 encoded string.
   *
   * @param string $encoded
   *   The encoded string.
   *
   * @return string
   *   The decoded string.
   */
  public static function decode(string $encoded): string {
    $encoded = str_replace(['-', '_'], ['+', '/'], $encoded);
    // Padding is not required for decoding, so don't add it back.
    return base64_decode($encoded);
  }

}
