# Quick Node Status Toggler

## Overview

This module adds a convenient toggle switch to the content listing page, allowing administrators to quickly publish or unpublish nodes without having to open each node individually.

## Problem Solved

In standard Drupal, changing a node's published status requires:
1. Opening the node edit form
2. Scrolling to find the "Published" checkbox
3. Saving the node
4. Returning to the content listing

This module streamlines this workflow by adding an on/off toggle switch directly in the content listing table.

## Features

- **Quick Toggle**: One-click publish/unpublish from the content listing
- **Visual Feedback**: Modern toggle switch with clear on/off states
- **AJAX-Powered**: Updates happen instantly without page reload
- **Permission-Aware**: Only shows for users with edit permissions
- **Success Messages**: Confirms each status change
- **Accessible**: Keyboard-friendly and screen reader compatible
- **Responsive**: Works on mobile and desktop
- **Compatible**: Works with Drupal 9, 10, and 11

## Installation

### Via Composer (Recommended)

```bash
composer require drupal/quick_node_status_toggler
drush en quick_node_status_toggler
```

### Manual Installation

1. Download the module
2. Place it in `/modules/custom/quick_node_status_toggler`
3. Enable it: `drush en quick_node_status_toggler`
4. Or enable via UI: Admin → Extend → Enable "Quick Node Status Toggler"

## Usage

### Automatic Setup

Once enabled, the module automatically adds a "Quick Status Toggle" field to the default Content view.

### Manual Setup (Optional)

If you want to add the toggle to a custom view:

1. Go to Structure → Views
2. Edit your content listing view
3. Add a new field: "Quick Status Toggle"
4. Save the view

The toggle will now appear in your content listing!

## How It Works

1. **Toggle Switch**: Click the switch to change status
2. **AJAX Request**: The module sends a secure request to update the node
3. **Instant Update**: The node status changes without page reload
4. **Visual Confirmation**: The toggle updates and a success message appears

## Requirements

- Drupal 9.x, 10.x, or 11.x
- Node module (core)
- Views module (core)
- jQuery (core)

## Permissions

The toggle respects Drupal's permission system:
- Users must have permission to edit the specific node
- The toggle only appears for nodes the user can edit
- Requires "Administer nodes" permission for the toggle route

## Technical Details

### Architecture

- **Views Field Plugin**: Renders the toggle in Views
- **Controller**: Handles AJAX requests to update node status
- **CSRF Protection**: Secure token-based authentication
- **Drupal Messages**: Uses core messaging system for feedback

### Files Structure

```
quick_node_status_toggler/
├── src/
│   ├── Controller/
│   │   └── NodeStatusToggleController.php
│   └── Plugin/
│       └── views/
│           └── field/
│               └── QuickNodeStatusToggleField.php
├── templates/
│   └── quick-node-status-toggle.html.twig
├── js/
│   └── toggle.js
├── css/
│   └── toggle.css
├── quick_node_status_toggler.info.yml
├── quick_node_status_toggler.module
├── quick_node_status_toggler.routing.yml
└── quick_node_status_toggler.libraries.yml
```

## Customization

### Styling

You can override the default styles by adding CSS to your theme:

```css
.quick-status-toggle {
  /* Your custom styles */
}
```

### Template Override

Copy `quick-node-status-toggle.html.twig` to your theme's templates directory and customize as needed.

## Troubleshooting

### Toggle doesn't appear
- Ensure the module is enabled
- Check that you have permission to edit nodes
- Verify the field is added to your view

### Toggle doesn't work
- Check browser console for JavaScript errors
- Verify CSRF token is being generated
- Ensure you have "Administer nodes" permission

### Status doesn't update
- Check that the node is not locked by another user
- Verify database connection
- Check Drupal logs for errors

## Security

- **CSRF Protection**: All requests are protected with CSRF tokens
- **Permission Checks**: Validates user permissions before any update
- **Access Control**: Respects node-level access controls
- **Error Handling**: Graceful error handling prevents data corruption

## Performance

- **Lightweight**: Minimal JavaScript and CSS
- **AJAX**: No page reloads required
- **Efficient**: Only loads on pages with the toggle field
- **Optimized**: Uses Drupal's built-in caching

## Roadmap

Future enhancements may include:
- Bulk toggle for multiple nodes
- Keyboard shortcuts
- Customizable toggle styles
- Support for other entity types
- Scheduled publishing integration

## Maintainers

- nikhileshpaul - https://www.drupal.org/u/nikhileshpaul

## License

GPL-2.0-or-later

## Support

- **Issue Queue**: https://www.drupal.org/project/issues/quick_node_status_toggler
- **Project Page**: https://www.drupal.org/project/quick_node_status_toggler

## Credits

Developed to improve content management workflow efficiency in Drupal.
