<?php

namespace Drupal\quick_node_status_toggler\Plugin\views\field;

use Drupal\Core\Url;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Field handler to display quick status toggle.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("quick_node_status_toggle_field")
 */
class QuickNodeStatusToggleField extends FieldPluginBase
{

    /**
     * {@inheritdoc}
     */
    public function query()
    {
        // Leave empty to avoid a query on this field.
    }

    /**
     * {@inheritdoc}
     */
    public function render(ResultRow $values)
    {
        $node = $this->getEntity($values);

        if (!$node || !$node->access('update')) {
            return [];
        }

        // Generate CSRF token for the specific route.
        // Explicitly using the leading slash which is required for _csrf_token validation.
        $path = '/admin/content/toggle-status/' . $node->id();
        $token = \Drupal::csrfToken()->get($path);

        $build = [
            '#theme' => 'quick_node_status_toggle',
            '#node_id' => $node->id(),
            '#status' => $node->isPublished(),
            '#csrf_token' => $token,
        ];

        // Attach the library at the top level of the render array.
        $build['#attached']['library'][] = 'quick_node_status_toggler/toggle';

        return $build;
    }

}
