<?php

namespace Drupal\rac;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\user\RoleStorageInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Permissions generation Role Access grants.
 */
class AccessPermissions implements ContainerInjectionInterface {

  use StringTranslationTrait;

  protected RoleStorageInterface $userRoleStorage;

  /**
   * Constructs a TaxonomyViewsIntegratorPermissions instance.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_manager
   *   The entity manager.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager) {
    $this->userRoleStorage = $entity_type_manager->getStorage('user_role');
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static($container->get('entity_type.manager'));
  }

  /**
   * Returns an array of role access permissions.
   *
   * @return array
   *   A list of generated permissions.
   */
  public function permissions() {
    $ops = ['view', 'update'];
    $permissions = [];
    $roles = $this->userRoleStorage->loadMultiple();
    foreach ($ops as $op) {
      foreach ($roles as $role) {
        $permission = "RAC_" . $op . "_" . $role->id();
        $permissions[$permission] = [
          'title' => $this->t("@op Content for Role @label", ['@op' => $op, '@label' => $role->label()]),
          'restrict access' => TRUE,
        ];
      }
    }
    return $permissions;
  }

}
