# RAIL AI Provider Module

## Overview

The RAIL AI Provider module integrates RAIL (Responsible AI Labs) services with the Drupal AI module ecosystem. It provides both AI provider capabilities and comprehensive ethical guardrails using RAIL's 8 Dimensions of Ethical AI framework.

## Features

### RAIL AI Provider
- Direct integration with RAIL AI services
- Support for chat-based AI interactions
- Configurable API endpoints and authentication
- Comprehensive error handling and logging

### RAIL Ethical Dimensions Guardrail
- **8 Ethical Dimensions**: Fairness, Safety, Reliability, Transparency, Privacy, Accountability, Inclusivity, User Impact
- **Weighted Scoring**: Configurable weights for each dimension
- **Critical Dimensions**: Safety and Privacy always stop processing on violation
- **Flexible Actions**: Stop, rewrite, or warn on violations
- **Configuration Presets**: Strict, Balanced, and Permissive modes
- **Real-time Validation**: Immediate feedback and recommendations
- **Import/Export**: Configuration backup and sharing

## Requirements

- Drupal 10.0 or higher
- AI module 2.x or higher
- PHP 8.1 or higher
- RAIL API account and credentials
- HTTPS-enabled web server (required for API communication)

## Installation

### Via Composer (Recommended)
```bash
composer require drupal/rail_ai_provider
drush en rail_ai_provider
```

### Manual Installation
1. Download the module to `modules/contrib/rail_ai_provider`
2. Enable the module: `drush en rail_ai_provider`
3. Clear caches: `drush cr`

## Configuration

### RAIL AI Provider Setup
1. Navigate to **Configuration → AI → AI Providers**
2. Add a new RAIL AI Provider
3. Configure your RAIL API endpoint and credentials
4. Test the connection
5. Save the configuration

### RAIL Ethical Dimensions Guardrail Setup
1. Navigate to **Configuration → AI → Guardrails**
2. Add a new RAIL Ethical Dimensions Guardrail
3. Configure API settings (endpoint URL and API key)
4. Select evaluation mode (input, output, or both)
5. Choose action on violation (stop, rewrite, or warn)
6. Configure ethical dimensions:
   - Enable relevant dimensions
   - Set weights (importance) for each dimension
   - Set thresholds (minimum scores) for each dimension
7. Test the configuration
8. Save and add to guardrail sets as needed

## Quick Start Guide

### Basic Protection Setup
1. **Enable the module** and clear caches
2. **Get RAIL credentials** from your RAIL account dashboard
3. **Create a guardrail** with these minimal settings:
   - Enable Safety and Privacy dimensions
   - Use default weights (2.0 for critical dimensions)
   - Set overall threshold to 7.0
   - Choose "Stop processing" action
4. **Test with sample content** to verify functionality
5. **Add to guardrail sets** for your AI operations

### Using Configuration Presets
For quick setup, use the built-in presets:
- **Strict Mode**: Maximum protection for production environments
- **Balanced Mode**: Recommended for most applications  
- **Permissive Mode**: Relaxed settings for development

## Usage Examples

### Content Moderation Platform
```json
{
  "enabled_dimensions": ["fairness", "safety", "privacy", "inclusivity"],
  "dimension_weights": {
    "fairness": 2.0,
    "safety": 2.5,
    "privacy": 2.0,
    "inclusivity": 1.5
  },
  "overall_threshold": 7.5,
  "action_on_violation": "stop"
}
```

### Customer Service Chatbot
```json
{
  "enabled_dimensions": ["safety", "reliability", "user_impact"],
  "dimension_weights": {
    "safety": 2.0,
    "reliability": 1.5,
    "user_impact": 1.5
  },
  "overall_threshold": 7.0,
  "action_on_violation": "rewrite"
}
```

### Development Environment
```json
{
  "enabled_dimensions": ["safety", "privacy"],
  "dimension_weights": {
    "safety": 1.0,
    "privacy": 1.0
  },
  "overall_threshold": 5.0,
  "action_on_violation": "warn"
}
```

## API Integration

### RAIL API Requirements
- Valid RAIL account with API access
- HTTPS endpoint URL (provided by RAIL)
- API key for authentication
- Network access to RAIL services

### Supported Operations
- Content evaluation across ethical dimensions
- Real-time scoring and violation detection
- Batch processing capabilities
- Comprehensive error handling

## Security Considerations

### API Security
- All API communications use HTTPS
- API keys are stored securely in Drupal configuration
- Input validation and sanitization
- Rate limiting and timeout protection

### Data Privacy
- Content is transmitted to RAIL API for evaluation
- No persistent storage of evaluated content by default
- Configurable logging levels for privacy compliance
- Fail-open approach prevents data loss on API failures

## Performance Optimization

### Best Practices
- Enable only relevant dimensions for your use case
- Use appropriate timeout values (60-120 seconds)
- Implement caching for repeated evaluations
- Monitor API usage and response times

### Monitoring
- Built-in logging and monitoring capabilities
- API usage tracking and statistics
- Performance metrics and alerting
- Integration with Drupal's logging system

## Troubleshooting

### Common Issues
- **Connection failures**: Check API credentials and network connectivity
- **Timeout errors**: Increase timeout values or reduce enabled dimensions
- **Validation errors**: Review dimension configuration and thresholds
- **Performance issues**: Optimize dimension selection and implement caching

### Debug Mode
Enable debug logging for detailed troubleshooting:
```php
// In settings.php
$config['system.logging']['error_level'] = 'verbose';
```

### Log Locations
- **Drupal logs**: Admin → Reports → Recent log messages
- **Module logs**: Filter by "rail_ai_provider" source
- **API logs**: Check network and server logs for API communication

## Documentation

### Comprehensive Guides
- **Configuration Guide**: `help/rail_ethical_dimensions_guardrail.md`
- **Configuration Examples**: `examples/configuration_examples.md`
- **Troubleshooting Guide**: `troubleshooting/common_issues.md`

### Online Resources
- [RAIL Official Documentation](https://rail.com/docs)
- [Drupal AI Module Documentation](https://drupal.org/project/ai)
- [Module Issue Queue](https://drupal.org/project/issues/rail_ai_provider)

## Development

### Architecture
- Plugin-based architecture following Drupal standards
- Service-oriented design for modularity
- Comprehensive error handling and logging
- Extensive configuration validation

### Testing
- Unit tests for core functionality
- Integration tests for API communication
- Configuration validation tests
- Performance and load testing

### Contributing
1. Fork the project repository
2. Create a feature branch
3. Make your changes with tests
4. Submit a pull request
5. Follow Drupal coding standards

## Support

### Getting Help
- **Module Issues**: Use the Drupal project issue queue
- **RAIL API Issues**: Contact RAIL support directly
- **Configuration Questions**: Consult the documentation or community forums

### Commercial Support
- Professional configuration and optimization services available
- Custom integration development
- Training and consultation services
- Enterprise support contracts

## License

This module is licensed under the GNU General Public License v2.0 or later.
See the LICENSE.txt file for details.

## Changelog

### Version 1.0.0
- Initial release with RAIL AI Provider
- RAIL Ethical Dimensions Guardrail implementation
- Configuration presets and import/export
- Comprehensive documentation and examples

### Recent Updates
- Enhanced configuration UI with tooltips and validation
- Real-time recommendations and feedback
- Improved error handling and troubleshooting guides
- Performance optimizations and monitoring capabilities

## Credits

Developed by the Drupal AI community in collaboration with RAIL (Responsible AI Labs).

Special thanks to contributors and the broader Drupal and AI ethics communities for their support and feedback.