# RAIL Ethical Dimensions Guardrail - Configuration Examples

This document provides practical configuration examples for different use cases and scenarios.

## Basic Configurations

### Minimal Protection (Safety Only)
**Use Case**: Quick setup with essential safety protection
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "stop",
  "overall_threshold": 7.0,
  "enabled_dimensions": ["safety"],
  "dimension_weights": {
    "safety": 2.0
  },
  "dimension_thresholds": {
    "safety": 8.0
  }
}
```

### Essential Protection (Safety + Privacy)
**Use Case**: Basic protection for most applications
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "stop",
  "overall_threshold": 7.0,
  "enabled_dimensions": ["safety", "privacy"],
  "dimension_weights": {
    "safety": 2.0,
    "privacy": 2.0
  },
  "dimension_thresholds": {
    "safety": 8.0,
    "privacy": 8.0
  }
}
```

## Industry-Specific Configurations

### Healthcare Applications
**Focus**: Safety, Privacy, Reliability, Accountability
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "stop",
  "overall_threshold": 8.0,
  "enabled_dimensions": ["safety", "privacy", "reliability", "accountability"],
  "dimension_weights": {
    "safety": 2.5,
    "privacy": 2.5,
    "reliability": 2.0,
    "accountability": 1.5
  },
  "dimension_thresholds": {
    "safety": 9.0,
    "privacy": 9.0,
    "reliability": 8.5,
    "accountability": 8.0
  }
}
```

### Educational Platforms
**Focus**: Safety, Fairness, Inclusivity, Reliability
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "stop",
  "overall_threshold": 7.5,
  "enabled_dimensions": ["safety", "fairness", "inclusivity", "reliability"],
  "dimension_weights": {
    "safety": 2.0,
    "fairness": 1.5,
    "inclusivity": 1.5,
    "reliability": 1.5
  },
  "dimension_thresholds": {
    "safety": 8.5,
    "fairness": 7.5,
    "inclusivity": 7.5,
    "reliability": 7.5
  }
}
```

### Financial Services
**Focus**: Privacy, Reliability, Accountability, Transparency
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "stop",
  "overall_threshold": 8.0,
  "enabled_dimensions": ["privacy", "reliability", "accountability", "transparency"],
  "dimension_weights": {
    "privacy": 2.5,
    "reliability": 2.0,
    "accountability": 2.0,
    "transparency": 1.5
  },
  "dimension_thresholds": {
    "privacy": 9.0,
    "reliability": 8.5,
    "accountability": 8.0,
    "transparency": 7.5
  }
}
```

### Content Moderation Platform
**Focus**: All dimensions with emphasis on fairness and safety
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "stop",
  "overall_threshold": 7.5,
  "enabled_dimensions": ["fairness", "safety", "reliability", "privacy", "inclusivity", "user_impact"],
  "dimension_weights": {
    "fairness": 2.0,
    "safety": 2.5,
    "reliability": 1.5,
    "privacy": 2.0,
    "inclusivity": 1.5,
    "user_impact": 1.0
  },
  "dimension_thresholds": {
    "fairness": 8.0,
    "safety": 8.5,
    "reliability": 7.5,
    "privacy": 8.0,
    "inclusivity": 7.5,
    "user_impact": 7.0
  }
}
```

## Use Case Specific Configurations

### Customer Service Chatbot
**Focus**: Safety, Reliability, User Impact, Transparency
```json
{
  "version": "1.0",
  "evaluation_mode": "output",
  "action_on_violation": "rewrite",
  "overall_threshold": 7.0,
  "enabled_dimensions": ["safety", "reliability", "user_impact", "transparency"],
  "dimension_weights": {
    "safety": 2.0,
    "reliability": 1.5,
    "user_impact": 1.5,
    "transparency": 1.0
  },
  "dimension_thresholds": {
    "safety": 8.0,
    "reliability": 7.5,
    "user_impact": 7.0,
    "transparency": 6.5
  }
}
```

### Creative Writing Assistant
**Focus**: Safety, User Impact (permissive for creativity)
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "warn",
  "overall_threshold": 6.0,
  "enabled_dimensions": ["safety", "user_impact"],
  "dimension_weights": {
    "safety": 1.5,
    "user_impact": 1.0
  },
  "dimension_thresholds": {
    "safety": 7.0,
    "user_impact": 6.0
  }
}
```

### Legal Document Review
**Focus**: Reliability, Accountability, Transparency, Privacy
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "stop",
  "overall_threshold": 8.5,
  "enabled_dimensions": ["reliability", "accountability", "transparency", "privacy"],
  "dimension_weights": {
    "reliability": 2.5,
    "accountability": 2.0,
    "transparency": 2.0,
    "privacy": 2.0
  },
  "dimension_thresholds": {
    "reliability": 9.0,
    "accountability": 8.5,
    "transparency": 8.0,
    "privacy": 8.5
  }
}
```

### Social Media Content Generation
**Focus**: Fairness, Safety, Inclusivity, User Impact
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "stop",
  "overall_threshold": 7.5,
  "enabled_dimensions": ["fairness", "safety", "inclusivity", "user_impact"],
  "dimension_weights": {
    "fairness": 2.0,
    "safety": 2.0,
    "inclusivity": 1.5,
    "user_impact": 1.5
  },
  "dimension_thresholds": {
    "fairness": 8.0,
    "safety": 8.0,
    "inclusivity": 7.5,
    "user_impact": 7.0
  }
}
```

## Development and Testing Configurations

### Development Environment
**Focus**: Relaxed thresholds for testing
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "warn",
  "overall_threshold": 5.0,
  "enabled_dimensions": ["safety", "privacy"],
  "dimension_weights": {
    "safety": 1.0,
    "privacy": 1.0
  },
  "dimension_thresholds": {
    "safety": 6.0,
    "privacy": 6.0
  }
}
```

### Quality Assurance Testing
**Focus**: All dimensions with moderate thresholds
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "warn",
  "overall_threshold": 6.5,
  "enabled_dimensions": ["fairness", "safety", "reliability", "transparency", "privacy", "accountability", "inclusivity", "user_impact"],
  "dimension_weights": {
    "fairness": 1.0,
    "safety": 1.5,
    "reliability": 1.0,
    "transparency": 1.0,
    "privacy": 1.5,
    "accountability": 1.0,
    "inclusivity": 1.0,
    "user_impact": 1.0
  },
  "dimension_thresholds": {
    "fairness": 6.5,
    "safety": 7.0,
    "reliability": 6.5,
    "transparency": 6.0,
    "privacy": 7.0,
    "accountability": 6.0,
    "inclusivity": 6.5,
    "user_impact": 6.0
  }
}
```

## Advanced Configurations

### Multi-Tenant Platform (Strict)
**Focus**: Maximum protection for shared environments
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "stop",
  "overall_threshold": 8.5,
  "enabled_dimensions": ["fairness", "safety", "reliability", "transparency", "privacy", "accountability", "inclusivity", "user_impact"],
  "dimension_weights": {
    "fairness": 2.0,
    "safety": 3.0,
    "reliability": 2.0,
    "transparency": 1.5,
    "privacy": 3.0,
    "accountability": 1.5,
    "inclusivity": 2.0,
    "user_impact": 1.5
  },
  "dimension_thresholds": {
    "fairness": 8.5,
    "safety": 9.0,
    "reliability": 8.5,
    "transparency": 8.0,
    "privacy": 9.0,
    "accountability": 8.0,
    "inclusivity": 8.5,
    "user_impact": 8.0
  }
}
```

### Research and Analytics
**Focus**: Reliability and Transparency with moderate other dimensions
```json
{
  "version": "1.0",
  "evaluation_mode": "both",
  "action_on_violation": "warn",
  "overall_threshold": 7.0,
  "enabled_dimensions": ["reliability", "transparency", "accountability", "privacy"],
  "dimension_weights": {
    "reliability": 2.5,
    "transparency": 2.0,
    "accountability": 1.5,
    "privacy": 2.0
  },
  "dimension_thresholds": {
    "reliability": 8.5,
    "transparency": 8.0,
    "accountability": 7.5,
    "privacy": 8.0
  }
}
```

## Configuration Tips

### Weight Distribution Guidelines
- **Total Weight Range**: Keep total weights between 4.0-16.0 for balanced evaluation
- **Critical Dimensions**: Always use higher weights (1.5-3.0) for Safety and Privacy
- **Specialized Use Cases**: Increase weights for dimensions most relevant to your domain
- **Balanced Approach**: Use weights of 1.0-1.5 for most dimensions in general applications

### Threshold Setting Strategies
- **Conservative**: Use thresholds of 8.0+ for strict evaluation
- **Moderate**: Use thresholds of 6.5-7.5 for balanced evaluation  
- **Permissive**: Use thresholds of 5.0-6.5 for lenient evaluation
- **Critical Dimensions**: Always use higher thresholds (8.0+) for Safety and Privacy

### Action Selection Guide
- **Stop**: Use for production environments where violations must be prevented
- **Rewrite**: Use when you want to give users a chance to modify content
- **Warn**: Use for development, testing, or when you want to monitor without blocking

### Performance Considerations
- **Fewer Dimensions**: Enable only relevant dimensions for better performance
- **Timeout Settings**: Use 60-120 seconds for most applications
- **Caching**: Consider implementing caching for repeated content evaluation
- **Monitoring**: Track API response times and adjust timeouts accordingly

## Import Instructions

To use these configurations:

1. Copy the JSON configuration you want to use
2. Go to your RAIL Ethical Dimensions Guardrail configuration form
3. Open the "Import/Export Configuration" section
4. Paste the JSON into the "Configuration JSON" textarea
5. Click "Import Configuration"
6. Review the applied settings
7. Add your API endpoint URL and key
8. Save the configuration

## Validation Checklist

Before deploying a configuration:

- [ ] At least one dimension is enabled
- [ ] Critical dimensions (Safety, Privacy) are enabled for production use
- [ ] Weights are within reasonable ranges (0.1-5.0)
- [ ] Thresholds are appropriate for your use case (0.0-10.0)
- [ ] Overall threshold matches your risk tolerance
- [ ] Action on violation is appropriate for your environment
- [ ] API credentials are configured and tested
- [ ] Configuration has been tested with sample content