/**
 * @file
 * JavaScript for RAIL Ethical Dimensions Guardrail configuration form.
 */

(function ($, Drupal) {
  'use strict';

  /**
   * Behavior for range slider value display updates.
   */
  Drupal.behaviors.railGuardrailConfig = {
    attach: function (context, settings) {
      // Handle all range sliders
      $('input[type="range"]', context).once('rail-range-display').each(function () {
        var $slider = $(this);
        var $valueDisplay = $slider.siblings('.range-value-display');
        
        // If no value display exists, create one
        if ($valueDisplay.length === 0) {
          $valueDisplay = $('<span class="range-value-display"></span>');
          $slider.after($valueDisplay);
        }
        
        // Function to update display value
        function updateDisplay() {
          var value = parseFloat($slider.val());
          var step = parseFloat($slider.attr('step')) || 0.1;
          
          // Format value based on step size
          var displayValue;
          if (step >= 1) {
            displayValue = Math.round(value);
          } else if (step >= 0.1) {
            displayValue = value.toFixed(1);
          } else {
            displayValue = value.toFixed(2);
          }
          
          $valueDisplay.text(displayValue);
        }
        
        // Update display on load
        updateDisplay();
        
        // Update display on input and change events
        $slider.on('input change', function() {
          updateDisplay();
        });
      });
    }
  };

})(jQuery, Drupal);