# Changelog

All notable changes to the RAIL Score Drupal module will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).


## [1.0.3] - 2025-11-18 - Stable Scoring Endpoints

### Overview
This release ensures stable support for RAIL Score API evaluation endpoints with enhanced UI/UX improvements. Focus on reliable content scoring with comprehensive dimension analysis display.

### Added

#### Dimension Scores Display
- **Complete dimension breakdown** now properly displayed in evaluation results
- Shows all 8 RAIL dimensions with individual scores, confidence levels, and explanations
- Per-dimension issues and recommendations when available
- Visual indicators for score levels (excellent/good/warning/danger)

#### Configuration Enhancements
- **API Key visibility toggle** - Show/hide API key with checkbox in configuration form
- **Dimension-level thresholds** - Set minimum score requirements per dimension
- **Dimension-level confidence** - Configure confidence requirements (0-1) for each dimension
- **Coming Soon section** - Clear indication of upcoming features (Reprompt, Compliance endpoints)

#### UI/UX Improvements
- Password-style API key field with monospace font for better readability
- Styled "Coming Soon" section with yellow dashed border for future endpoints
- Enhanced Advanced Settings with dimension-specific configurations
- Cleaner evaluation results without internal API metadata

### Changed

#### API Response Handling
- **Fixed dimension scores parsing** - Now correctly reads `dimension_scores` from API response
- Updated to handle both `dimension_scores` and legacy `dimensions` keys for compatibility
- Enhanced debug logging to properly detect and display dimension data

#### Configuration Form Reorganization
- **Removed** "Accepted Score for Reprompt" from Advanced Settings
- **Removed** "Confidence Threshold" from Advanced Settings
- **Added** Dimension-specific score thresholds (8 fields)
- **Added** Dimension-specific confidence requirements (8 fields)
- Reprompt endpoint options now disabled and marked "Coming Soon"

#### Metadata Display
- **Removed technical metadata** from standard evaluation results
- Metadata (req_id, timestamp, tier, credits_cost) now only visible in debug mode
- Cleaner JSON output in debug view (excludes internal fields)

### Fixed

#### Evaluation Display
- **Critical Fix**: Dimension scores now properly displayed for all evaluations
- API returns `result.dimension_scores` but code was checking `result.dimensions`
- Added fallback support for both response formats
- Debug mode properly logs dimension discovery

#### Scoring Endpoints
- ✅ `/railscore/v1/score/basic` - Fast scoring with dimension breakdowns
- ✅ `/railscore/v1/score/detailed` - Comprehensive analysis with explanations
- ✅ `/railscore/v1/score/basic/dimension` - Single dimension evaluation
- ✅ `/railscore/v1/score/detailed/dimension` - Detailed single dimension analysis
- ✅ `/health` - API health check
- ✅ `/verify` - API key verification

### Technical Details

#### Modified Files
- `rail_score.module` (lines 302, 422-470) - Dimension display and metadata handling
- `src/RailScoreClient.php` (lines 135-145, 624) - Response parsing and debug logging
- `src/Form/RailScoreConfigForm.php` (lines 89-120, 163-189, 271-327, 450-500) - Configuration UI
- `js/rail-score-admin.js` (lines 47-57) - API key toggle functionality
- `css/rail-score-admin.css` (lines 166-221) - Styling for new UI elements
- `.gitignore` - Updated to exclude test files

#### API Compatibility
- **Stable**: All evaluation scoring endpoints fully tested and working
- **Coming Soon**: Reprompt endpoints (planned for v1.0.4)
- **Coming Soon**: Compliance endpoints (GDPR, CCPA)
- **Coming Soon**: Content generation endpoints

#### Configuration Schema Changes
- Added `dimension_thresholds` (mapping of dimension names to minimum scores)
- Added `dimension_confidence` (mapping of dimension names to minimum confidence)
- Deprecated `accepted_score` and `confidence_threshold` (will be removed in v2.0)

### Upgrade Notes
- ✅ No database updates required
- ✅ Existing configurations remain valid
- ✅ Fully backward compatible with v1.0.2
- ⚠️ Clear Drupal cache after updating: `drush cr`
- 💡 Review new dimension-level settings in Advanced configuration
- 💡 Toggle debug mode OFF for production sites (removes metadata display)

### Testing
All scoring endpoints tested with production RAIL Score API:
- Basic and detailed scoring endpoints verified
- Dimension-specific endpoints verified
- Response format compatibility confirmed
- UI display of all dimension data validated

---

**Note**: This is a stable release focused on evaluation endpoints. Reprompt and compliance features are planned for future releases.


## [1.0.2] - 2025-11-06

### Fixed
- **Test Connection Button**: Fixed AJAX callback to use form values instead of saved configuration when testing API connection. The "Test Connection" button now properly tests with the API key and base URL currently entered in the form fields, not previously saved values. (Issue: Connection test was always using old/empty credentials)
- **API Connection Testing**: Updated `testConnection()` method to support the correct RAIL Score API endpoints due to upstream changes by Responsible AI Labs:
  - Now checks root endpoint (`/`) to verify API availability (no authentication required)
  - Falls back to `/health/check` endpoint if root endpoint is unavailable
  - Uses `/verify` endpoint for API key validation with proper authentication
  - Improved error handling and logging for different response scenarios (200, 401, 403, 404)
  - Better timeout handling (10 seconds instead of 30)

### Changed
- **RailScoreClient::testConnection()**: Method signature updated to accept optional `$api_key` and `$base_url` parameters, allowing both form-based testing and programmatic testing
- Enhanced error logging with clearer messages to help diagnose connection issues
- Added `http_errors: FALSE` option to handle non-200 responses gracefully
- Updated to use current RAIL Score API endpoints as specified by Responsible AI Labs

### Technical Details
- **Modified Files**:
  - `src/Form/RailScoreConfigForm.php` (lines 204-208)
  - `src/RailScoreClient.php` (lines 215-295)
- **Affected Version**: 1.0.0
- **External Dependency**: RAIL Score API endpoint changes by Responsible AI Labs

### Upgrade Notes
- No database updates required
- No configuration changes needed
- Fully backward compatible with 1.0.0
- Clear Drupal cache after updating: `drush cr`


## [1.0.1] - Minor Fix

## [1.0.0] - 2024-11-04

### Added

#### Core Features
- Initial release of RAIL Score Drupal module
- Full integration with RAIL Score API for content evaluation
- Support for Drupal 9, 10, and 11
- PHP 8.1+ compatibility

#### API Client
- `RailScoreClient` service for API interactions
- Content evaluation with `evaluate()` method
- GDPR compliance checking with `checkGdprCompliance()` method
- Usage statistics retrieval with `getUsageStats()` method
- Connection testing with `testConnection()` method
- Comprehensive error handling and logging

#### Configuration
- Admin configuration form at `/admin/config/content/rail-score`
- API key and base URL configuration
- Configurable quality threshold (0-10 scale)
- Auto-evaluation toggle
- Auto-unpublish low-scoring content option
- Selectable evaluation dimensions (8 dimensions)
- Content type selection for evaluation
- AJAX connection testing
- Form validation with detailed error messages

#### Dashboard
- Statistics dashboard at `/admin/reports/rail-score`
- API usage statistics display
- Local evaluation statistics
- Recent evaluations table with sorting
- Score-based visual indicators
- Quick action links
- Empty state messaging

#### Automatic Evaluation
- `hook_entity_presave()` implementation
- Automatic content evaluation on save
- Multi-field content extraction (title, body, custom fields)
- Threshold checking and warnings
- Auto-unpublish capability for low-scoring content
- Dimension score logging

#### Queue System
- `RailScoreEvaluationWorker` queue worker plugin
- Batch content evaluation support
- Cron-based processing (60 seconds per run)
- Error handling and retry logic
- Full result data storage option

#### Field Formatter
- `RailScoreFormatter` field formatter plugin
- Multiple display modes:
  - Badge mode
  - Progress bar mode
  - Text only mode
  - Full widget mode
- Configurable decimal places (0-2)
- Threshold indicator option
- Responsive design

#### Templates
- `rail-score-dashboard.html.twig` for dashboard display
- `rail-score-widget.html.twig` for score widgets
- Twig-based theming with proper documentation
- Score legend and status indicators
- Fully translatable strings

#### Styling & JavaScript
- Comprehensive admin CSS (`rail-score-admin.css`)
- Responsive design for mobile devices
- Visual score indicators (high/medium/low)
- Interactive JavaScript behaviors
- Drupal behaviors for dashboard and forms
- Real-time threshold display
- Auto-unpublish warning toggle
- Score-based row highlighting

#### Permissions
- `administer rail_score` - Configure module settings (restricted)
- `view rail_score dashboard` - Access statistics dashboard
- `evaluate content with rail_score` - Manually trigger evaluations

#### Developer Features
- PSR-4 autoloading
- Dependency injection throughout
- Event subscriber for entity operations
- Service container configuration
- Configuration schema definitions
- Helper functions (`rail_score_get_score()`, `rail_score_passes_threshold()`)
- Comprehensive hook implementations

#### Documentation
- Complete README.md with installation instructions
- API usage examples
- Troubleshooting guide
- Development guidelines
- Inline code documentation (PHPDoc)
- Twig template documentation
- MIT License

#### Logging
- Structured logging with context
- Evaluation tracking
- API error logging
- Configuration change tracking
- Cron run logging

#### Security
- Input validation on all forms
- Output sanitization in templates
- API key secure storage in configuration
- Access control via permissions
- CSRF protection (automatic in Drupal forms)
- SQL injection prevention via Entity API

#### Testing
- Functional test suite foundation
- Configuration form tests
- Test base classes
- PHPUnit integration

### Configuration Schema

```yaml
rail_score.settings:
  - api_key (string)
  - base_url (string)
  - auto_evaluate (boolean)
  - threshold (float, 0-10)
  - auto_unpublish (boolean)
  - dimensions (sequence of strings)
  - enabled_content_types (sequence of strings)
```

### Service Definitions

- `rail_score.client` - Main API client service
- `rail_score.entity_subscriber` - Entity event subscriber

### Routes

- `rail_score.settings` - Configuration form
- `rail_score.dashboard` - Statistics dashboard

### Plugin Types

- QueueWorker: `rail_score_evaluation`
- FieldFormatter: `rail_score_formatter`

### Theme Hooks

- `rail_score_dashboard`
- `rail_score_widget`

### Dependencies

- drupal:field
- drupal:node
- drupal:user
- guzzlehttp/guzzle ^7.0

## [Unreleased]

### Planned Features
- Bulk content re-evaluation UI
- Custom field support configuration
- Advanced dimension weight configuration
- API rate limiting handling
- Content score history tracking
- Exportable reports
- Integration with Drupal moderation workflows
- Multilingual support for evaluations
- Scheduled evaluation cron jobs
- Score trending and analytics
- REST API endpoints for external integrations
- Webhooks for real-time notifications

### Known Issues
- None reported

---

For more information, visit [https://www.drupal.org/project/rail_score](https://www.drupal.org/project/rail_score)
