# Random Coupon Generator

A small Drupal 10 admin module that generates large numbers of unique, non-sequential coupon codes using a prime-based obfuscation algorithm based on [this blog post](https://gdebrauwer.dev/blog/generating-unique-voucher-codes/) & the [wotzebra/unique-codes](https://github.com/wotzebra/unique-codes) package.

It provides an admin settings form and a generator form with an option to either output generated codes on the page or export them as a CSV download.

## Features
- Configure coupon length and character set.
- Configure obfuscating and max primes used by the generator algorithm.
- Generate N unique coupon codes in a single operation.
- Choose output: show codes on the page or download a CSV file.

## Requirements
This module does not require other modules. It does require the [wotzebra/unique-codes](https://github.com/wotzebra/unique-codes) package (installed automatically via Composer).

## Installation
1. Install the module via Composer.
2. Enable the module (via UI or Drush):
   ```sh
    drush en random_coupon_generator -y
   ```

## Configuration & usage
- Settings form: Admin → Configuration → System → Random coupon generator
   (`/admin/config/system/random-coupon-generator/settings`)
	- Obfuscating prime: a prime number used to obfuscate the base numbers.
	- Max prime: determines maximum unique count (must be smaller than obfuscating prime).
	- Default length: characters per coupon.
	- Character set: characters used for coupon generation.
	- Prefix / Suffix: optional strings added to each code.

- Generator form: Admin → Configuration → System → Random coupon generator → Generate coupons
   (`/admin/config/system/random-coupon-generator/generate`)
	- Fill in the number of codes to generate
	- Select Output:
		- Export to CSV (downloads a CSV file with one coupon per row)
		- Output on page (shows generated codes in a read-only textarea)

## Caveats & notes
- The delimiter feature was intentionally disabled in the initial module and is not available in the UI.
- Generating very large amounts (tens of thousands) may be memory- or time-consuming depending on your PHP limits. Use with caution and test on non-production systems if you plan large exports.
