# Ratatouille: Drupal Recipe Generator

This module provides a Drush command to generate Drupal recipes from your site's existing configuration and content. It offers a flexible workflow for creating reusable blueprints for features or entire site builds.

## Features

- **Interactive & Non-Interactive Modes**: Use the menu-driven interface (`drush ratatouille:cook`) for guided recipe creation or the non-interactive mode with command-line options for automation.
- **Configuration & Content Export**: Export configuration and content with full dependency resolution. The interactive mode includes autocompletion for content selection.
- **Dependency Management**: Automatically resolves module dependencies and allows for manual additions.
- **File Handling**: Copies files associated with content into the recipe's `files/` directory, with options to maintain the original folder structure.
- **Layout Builder Support**: Automatically detects and exports inline blocks created with Layout Builder.

## How to Use

1.  **Enable the module**:
    ```bash
    drush en ratatouille -y
    ```

2.  **Clear Caches**:
    ```bash
    drush cr
    ```

3.  **Run the generator**:
    ```bash
    drush ratatouille:cook
    ```

4.  Follow the interactive prompts to build your recipe.

### Non-Interactive Mode

```bash
drush ratatouille:cook --name=my_recipe --label="My Recipe" --include-config="system.site,node.type.*" --include-content="node:1" --add-modules="views,token"
```

**Available Options:**

- `--name`: Machine name for the recipe.
- `--label`: Human-readable label.
- `--description`: A short description.
- `--include-config`: Comma-separated list of configuration to include (wildcards `*` supported).
- `--include-content`: Comma-separated list of content to include (`entity_type:id`).
- `--add-modules`: Comma-separated list of modules to add.
- `--maintain-file-structure`: Maintain original file structure for copied files.

## Site-Specific Configuration

You can configure the module's behavior in your `settings.php` file.

### Conflicting Configurations

Define how to handle conflicting configurations:

```php
$settings['recipe_conflicting_configs'] = [
  'system.site' => 2, // Handle as an action.
  'user.role.administrator' => 3, // Omit the admin role.
  '*.performance' => 0, // Ask what to do.
];
```

- **0**: Ask the user.
- **1**: Import (default).
- **2**: Convert to a `config:actions` entry.
- **3**: Omit.

### Stream Wrapper Path

Override the default path for the `recipe://` stream wrapper:

```php
$settings['recipe_stream_wrapper_path'] = DRUPAL_ROOT . '/../private/recipes';
```

## Architecture

The module follows a service-oriented architecture:

- **`RecipeGeneratorCommands`**: The Drush command that orchestrates the recipe generation process.
- **`RecipeConfigurationHandler`**: Handles fetching and processing of configuration.
- **`RecipeContentHandler`**: Manages content-related operations.
- **`RecipeDependencyResolver`**: Resolves all dependencies for the recipe.
- **`RecipeFileGenerator`**: Writes the final recipe files.
- **`RecipeStreamWrapper`**: Provides the `recipe://` stream wrapper.
