<?php

namespace Drupal\ratatouille\StreamWrapper;

use Drupal\Core\StreamWrapper\LocalStream;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Defines a Drupal stream wrapper for recipes.
 *
 * This stream wrapper is used to access files within the /recipes directory
 * of a Drupal installation.
 */
class RecipeStreamWrapper extends LocalStream {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public static function getType() {
    return self::LOCAL_NORMAL;
  }

  /**
   * {@inheritdoc}
   */
  public function getName() {
    return $this->t('Recipe');
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->t('Provides access to files within Drupal recipes.');
  }

  /**
   * {@inheritdoc}
   */
  public function getDirectoryPath() {
    // Allow the path to be configured in settings.php, with a sensible default.
    return \Drupal::service('settings')->get('recipe_stream_wrapper_path', DRUPAL_ROOT . '/recipes');
  }

  /**
   * {@inheritdoc}
   */
  public function getExternalUrl() {
    // Construct the public URL for the file.
    $path = str_replace('\ ', '/', $this->getTarget());
    return static::baseUrl() . '/recipes/' . $path;
  }

}
