/**
 * @file
 * Modifies the Rate thumbsupdown rating.
 */

(function ($, Drupal) {
  Drupal.behaviors.ThumbsUpDownRating = {
    attach(context, settings) {
      $('body')
        .find('.thumbsupdown-rating-wrapper')
        .each(function () {
          // If element is editable, enable submit click.
          const isEdit = $(this).attr('can-edit');
          if (isEdit === 'true') {
            $(this)
              .find('label')
              .click(function (e) {
                $(this).find('input').prop('checked', true);
                $(this)
                  .closest('form')
                  .find('.thumbsupdown-rating-submit')
                  .trigger('click');
              });
          } else {
            this.querySelectorAll('label').forEach((label) => {
              label.style.cursor = 'default'; // Cursor to arrow.
            });
          }
        });
    },
  };
})(jQuery, Drupal);
