/**
 * @file
 * Installs @sentry/browser and updates library version.
 */

const yaml = require('js-yaml');
const fs = require('fs').promises;

const copyJs = fs.copyFile(
  'node_modules/@sentry/tracing/build/bundle.tracing.min.js',
  'js/bundle.tracing.min.js'
);
const copyMap = fs.copyFile(
  'node_modules/@sentry/tracing/build/bundle.tracing.min.js.map',
  'js/bundle.tracing.min.js.map'
);

let libraries;
const readYaml = fs.readFile('raven.libraries.yml', 'utf8').then((contents) => {
  libraries = yaml.load(contents);
});

let version;
const readJson = fs.readFile('package-lock.json', 'utf8').then((contents) => {
  version = JSON.parse(contents).dependencies['@sentry/tracing'].version;
});

const updateVersion = Promise.all([readYaml, readJson]).then(() => {
  libraries['sentry-browser'].version = version;
});

const writeVersion = Promise.all([updateVersion]).then(() =>
  fs.writeFile('raven.libraries.yml', yaml.dump(libraries))
);

Promise.all([copyJs, copyMap, writeVersion]).then(() =>
  console.log('Achievement unlocked.')
);
