<?php

namespace Drupal\raven\Config;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Raven configuration service.
 */
class Config implements ConfigInterface {

  public function __construct(
    protected ConfigFactoryInterface $configFactory,
    protected string $environment,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public function get(string $key): mixed {
    return $this->configFactory->get('raven.settings')->get($key);
  }

  /**
   * {@inheritdoc}
   */
  public function getBackendDsn(): ?string {
    return $this->getWithOverride('client_key', 'SENTRY_DSN');
  }

  /**
   * {@inheritdoc}
   */
  public function getEnvironment(): string {
    return $this->getWithOverride('environment', 'SENTRY_ENVIRONMENT') ?: $this->environment;
  }

  /**
   * {@inheritdoc}
   */
  public function getFrontendDsn(): ?string {
    return $this->getWithOverride('public_dsn', 'SENTRY_DSN');
  }

  /**
   * {@inheritdoc}
   */
  public function getRelease(): ?string {
    return $this->getWithOverride('release', 'SENTRY_RELEASE');
  }

  /**
   * Allow configuration to be overridden by environment variables.
   */
  protected function getWithOverride(string $key, string $index): ?string {
    return is_string($value = !empty($_SERVER[$index]) ? $_SERVER[$index] : $this->get($key)) ? $value : NULL;
  }

}
