<?php

namespace Drupal\raven\Config;

/**
 * Raven configuration interface.
 */
interface ConfigInterface {

  /**
   * Gets data from raven.settings configuration object.
   */
  public function get(string $key): mixed;

  /**
   * Gets the backend DSN.
   */
  public function getBackendDsn(): ?string;

  /**
   * Gets the environment.
   */
  public function getEnvironment(): string;

  /**
   * Gets the frontend DSN.
   */
  public function getFrontendDsn(): ?string;

  /**
   * Gets the release, if any.
   */
  public function getRelease(): ?string;

}
