<?php

namespace Drupal\rawdebug\Mixin;

/**
 * Use rawdebug for logging if it's installed.
 */
trait RawdebugTrait {

  /**
   * Is rawdebug installed?
   * 0 = we don't know
   * 1 = no
   * 2 = yes
   *
   * @var integer
   */
  protected $rawdebugExistenceValue = 0;

  /**
   * @see rawdebug()
   */
  protected function rawdebug(...$args) {
    if (!$this->rawdebugExistenceValue) {
      $this->rawdebugExistenceValue = function_exists('rawdebug') ? 2 : 1;
    }

    if ($this->rawdebugExistenceValue === 2) {
      rawdebug(...$args);
    }
  }

  /**
   * @see dbt()
   */
  protected function dbt($limit = 11, $withArgs = FALSE) {
    if (!$this->rawdebugExistenceValue) {
      $this->rawdebugExistenceValue = function_exists('dbt') ? 2 : 1;
    }

    if ($this->rawdebugExistenceValue === 2) {
      return dbt($limit, $withArgs);
    }

    return [];
  }

  /**
   * @see summerize()
   */
  protected function summerize($arg) {
    if (!$this->rawdebugExistenceValue) {
      $this->rawdebugExistenceValue = function_exists('summerize') ? 2 : 1;
    }

    if ($this->rawdebugExistenceValue === 2) {
      return summerize($arg);
    }

    return '';
  }

}
