# RDF SKOS

This module provides a dedicated entity type for SKOS modeling. The module requires access to a [triplestore database](https://en.wikipedia.org/wiki/Triplestore),
such as [Virtuoso 7](https://github.com/openlink/virtuoso-opensource).

## Upgrade from 0.11.0 to 1.0.0-alpha1

On `1.0.0-alpha1`, the `rdf_entity` module dependency has been removed and instead the `sparql_entity_storage` module has been
introduced (see the [rdf_entity module's Readme](https://github.com/ec-europa/rdf_entity#updating-from-10-alpha16-to-alpha17) for more information).

As suggested by the `rdf_entity` module itself, the following steps can be taken in order to update `rdf_skos` in production:

The update process needs to be split in three deployments, which will likely result into separate site releases.

**First deployment**

1. **Before you update `rdf_skos` to `1.0.0-alpha1`**, require an empty version of the `drupal/sparql_entity_storage` module:
   ```
   $ composer require drupal/sparql_entity_storage:dev-empty-module
   ```
2. Deploy to production.
3. Enable the module (this can be part of the deployment procedure above, depending on your setup).

At this point your site's `composer.json` should look like this:

```
{
    ...
    "openeuropa/rdf_skos": "~0.11.0",
    "drupal/sparql_entity_storage": "dev-empty-module",
    ...
}
```

**Second deployment**

1. Remove the empty `drupal/sparql_entity_storage` module requirement from your `composer.json`.
2. Require `drupal/rdf_entity` with the new `1.0-alpha21` version and `openeuropa/rdf_skos` with the new `1.0.0-alpha1` version.
3. Deploy to production.
4. Uninstall the `drupal/rdf_entity` module (this can be part of the deployment procedure above, depending on your setup).

At this point your site's `composer.json` should look like this:

```
{
    ...
    "openeuropa/rdf_skos": "~1.0.0-alpha1",
    "drupal/rdf_entity": "~1.0-alpha21",
    ...
}
```

**Third deployment**

1. Remove the `drupal/rdf_entity` dependency.
2. Deploy to production.

At this point your site's `composer.json` should look like this:

```
{
    ...
    "openeuropa/rdf_skos": "~1.0.0-alpha1",
    ...
}
```

After these steps your site should have the latest version `drupal/rdf_skos` module using `drupal/sparql_entity_storage`
and the `drupal/rdf_entity` module should no longer be in your codebase.

## Technical details and constraints

The module allows loading SKOS concept schemes and concepts as entities in Drupal. The entities will be
loaded from the graph IRIs specified in the related configuration.

Since all the graphs are passed to the methods for loading entities, this enforces the limitation of having unique IRIs
(IDs in Drupalese) for the SKOS entities present in all the graphs.

## Development setup

### Initial setup

You can build the test site by running the following steps.

* Install Virtuoso. The easiest way to do this is by using the [Triple store](https://git.fpfis.tech.ec.europa.eu/fpfis/triple-store) Docker container which also pre-imports the main Europa vocabularies.
* Install all the composer dependencies:

```
$ composer install
```

### Using Docker and DDEV

* This project is using [Docker and DDEV](https://ddev.readthedocs.io/en/latest/users/install/) for local development.

* Setup test site by running ddev:

```
$ ddev start
```
* Install dependencies using the following command:
```
$ ddev poser
```
* Symlink the project files into the test site:
```
$ ddev symlink-project
```
* Update configurations to detect expected Drupal and PHP versions:
```
$ ddev config --update
```
* Restart DDEV to apply the changes:
```
$ ddev restart
```
* Install the site using the following command:
```
$ ddev install
```
**Please note:** project files and directories are symlinked within the test site.

If you add a new file or directory in the root of the project, you need to re-run `ddev symlink-project` in order to make
sure they are be correctly symlinked.

Your test site will be available at `./web`.

* Visit the [ddev-drupal-contrib](https://github.com/ddev/ddev-drupal-contrib?tab=readme-ov-file#commands) for available commands to run different tests locally.
