<?php

namespace Drupal\reading_rating\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Defines the reading rating form interface.
 */
class ReadingRatingSettings extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'reading_rating_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['reading_rating.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('reading_rating.settings');

    $form['tabs'] = [
      '#type' => 'vertical_tabs',
      '#title' => $this->t('Text replacements'),
    ];

    $form['ratings'] = [
      '#type' => 'details',
      '#title' => t('Ratings'),
      '#group' => 'tabs',
    ];

    $form['grades'] = [
      '#type' => 'details',
      '#title' => t('Grade levels'),
      '#group' => 'tabs',
    ];

    $form['ratings']['rating_label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Rating label'),
      '#description' => $this->t('The label before the actual rating.'),
      '#default_value' => $config->get('text_replacements.rating_label') ?? $this->t('Reading score'),
      '#required' => TRUE,
    ];

    $form['ratings']['rating_empty'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Empty rating'),
      '#description' => $this->t('Rating text when textarea is empty'),
      '#default_value' => $config->get('text_replacements.rating_empty') ?? $this->t('Unknown'),
      '#required' => TRUE,
    ];

    $form['ratings']['rating_easy'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Easy rating'),
      '#default_value' => $config->get('text_replacements.rating_easy') ?? $this->t('Easy'),
      '#required' => TRUE,
    ];

    $form['ratings']['rating_moderate'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Moderate rating'),
      '#default_value' => $config->get('text_replacements.rating_moderate') ?? $this->t('Moderate'),
      '#required' => TRUE,
    ];

    $form['ratings']['rating_difficult'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Difficult rating'),
      '#default_value' => $config->get('text_replacements.rating_difficult') ?? $this->t('Difficult'),
      '#required' => TRUE,
    ];

    $form['grades']['grade_label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Grade rating label'),
      '#description' => $this->t('The label before the actual grade level.'),
      '#default_value' => $config->get('text_replacements.grade_label') ?? $this->t('Grade level'),
      '#required' => TRUE,
    ];

    $form['grades']['grade_very_easy'] = [
      '#type' => 'textfield',
      '#title' => $this->t('0-5 years of schooling'),
      '#default_value' => $config->get('text_replacements.grade_very_easy') ?? $this->t('Elementary school'),
      '#required' => TRUE,
    ];

    $form['grades']['grade_easy'] = [
      '#type' => 'textfield',
      '#title' => $this->t('6-8 years of schooling'),
      '#default_value' => $config->get('text_replacements.grade_easy') ?? $this->t('Middle school'),
      '#required' => TRUE,
    ];

    $form['grades']['grade_fairly_easy'] = [
      '#type' => 'textfield',
      '#title' => $this->t('9-12 years of schooling'),
      '#default_value' => $config->get('text_replacements.grade_fairly_easy') ?? $this->t('High school'),
      '#required' => TRUE,
    ];

    $form['grades']['grade_moderate'] = [
      '#type' => 'textfield',
      '#title' => $this->t('13-16 years of schooling'),
      '#default_value' => $config->get('text_replacements.grade_moderate') ?? $this->t('College'),
      '#required' => TRUE,
    ];

    $form['grades']['grade_difficult'] = [
      '#type' => 'textfield',
      '#title' => $this->t('16+ years of schooling'),
      '#default_value' => $config->get('text_replacements.grade_difficult') ?? $this->t('College graduate'),
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {

    $this->configFactory->getEditable('reading_rating.settings')
      // Ratings.
      ->set('text_replacements.rating_label', $form_state->getValue('rating_label'))
      ->set('text_replacements.rating_empty', $form_state->getValue('rating_empty'))
      ->set('text_replacements.rating_easy', $form_state->getValue('rating_easy'))
      ->set('text_replacements.rating_moderate', $form_state->getValue('rating_moderate'))
      ->set('text_replacements.rating_difficult', $form_state->getValue('rating_difficult'))

      // Grade levels.
      ->set('text_replacements.grade_label', $form_state->getValue('grade_label'))
      ->set('text_replacements.grade_very_easy', $form_state->getValue('grade_very_easy'))
      ->set('text_replacements.grade_easy', $form_state->getValue('grade_easy'))
      ->set('text_replacements.grade_fairly_easy', $form_state->getValue('grade_fairly_easy'))
      ->set('text_replacements.grade_moderate', $form_state->getValue('grade_moderate'))
      ->set('text_replacements.grade_difficult', $form_state->getValue('grade_difficult'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
