<?php

declare(strict_types=1);

namespace Drupal\rebuilder\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a Rebuilder attribute for plug-in discovery.
 *
 * @see \Drupal\rebuilder\PluginManager\RebuilderManagerInterface
 *
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class Rebuilder extends Plugin {

  /**
   * Constructs a Rebuilder attribute.
   *
   * @param string $id
   *   The plug-in ID.
   *
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $title
   *   The human readable title of the plug-in.
   *
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $description
   *   A brief human readable description of the plug-in.
   *
   * @param string[] $aliases
   *   (optional) Aliases for this plug-in, in addition to its plug-in ID.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $title,
    public readonly TranslatableMarkup $description,
    public readonly array $aliases = [],
  ) {}

}
