<?php

declare(strict_types=1);

namespace Drupal\rebuilder_test\Plugin\Rebuilder;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\rebuilder\Attribute\Rebuilder;
use Drupal\rebuilder\Plugin\Rebuilder\RebuilderBase;

/**
 * Test default output rebuilder plug-in.
 */
#[Rebuilder(
  id: 'test_has_default_output',
  title: new TranslatableMarkup('Test default output'),
  description: new TranslatableMarkup(
    'Test the default output of the Rebuilder plug-in.',
  ),
)]
class TestHasDefaultOutput extends RebuilderBase {

  /**
   * {@inheritdoc}
   */
  public function rebuild(array $options = []): void {
    // Doesn't set any custom output.
  }

}
