<?php

namespace Drupal\recaptcha_preloader\Hook;

use Drupal\recaptcha_preloader\Service\RecaptchaPreloaderHelperInterface;

/**
 * Implements hook_captcha().
 */
class RecaptchaPreloaderCaptchaHook {

  /**
   * RecaptchaPreloaderCaptchaHook constructor.
   *
   * @param \Drupal\recaptcha_preloader\Service\RecaptchaPreloaderHelperInterface $helper
   *   The helper.
   */
  public function __construct(
    protected RecaptchaPreloaderHelperInterface $helper,
  ) {}

  /**
   * Implements hook_captcha().
   */
  public function __invoke(string $op, string $captcha_type = ''): ?array {
    return $op === 'generate' && $captcha_type === 'reCAPTCHA'
      ? $this->helper->build() : NULL;
  }

}
