<?php

namespace Drupal\recaptcha_preloader\Hook;

use Drupal\Core\Form\FormStateInterface;
use Drupal\recaptcha_preloader\Service\RecaptchaPreloaderHelperInterface;

/**
 * Implements hook_element_info_alter().
 */
class RecaptchaPreloaderElementInfoAlterHook {

  /**
   * RecaptchaPreloaderElementInfoAlterHook constructor.
   *
   * @param \Drupal\recaptcha_preloader\Service\RecaptchaPreloaderHelperInterface $helper
   *   The helper.
   */
  public function __construct(
    protected RecaptchaPreloaderHelperInterface $helper,
  ) {}

  /**
   * Implements hook_element_info_alter().
   */
  public function __invoke(array &$info): void {
    if ($this->helper->isAvailable()) {
      array_unshift($info['captcha']['#process'], [static::class, 'process']);
    }
  }

  /**
   * Process callback for CAPTCHA form element.
   */
  public static function process(
    array &$element,
    FormStateInterface $form_state,
    array &$complete_form,
  ): array {
    if (($captcha_type = &$element['#captcha_type']) === 'default') {
      $captcha_type = \Drupal::config('captcha.settings')->get('default_challenge')
        ?: 'captcha/Math';
    }

    if ($captcha_type === 'recaptcha/reCAPTCHA') {
      $captcha_type = 'recaptcha_preloader/reCAPTCHA';
    }

    return $element;
  }

}
