<?php

namespace Drupal\recaptcha_preloader\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslationInterface;

/**
 * Implements hook_form_FORM_ID_alter().
 */
class RecaptchaPreloaderFormRecaptchaAdminSettingsAlterHook {

  use StringTranslationTrait;

  /**
   * RecaptchaPreloaderFormRecaptchaAdminSettingsAlterHook constructor.
   *
   * @param \Drupal\Core\StringTranslation\TranslationInterface $translation
   *   The string translation.
   * @param \Drupal\Core\Config\ConfigFactoryInterface|null $configFactory
   *   (optional) The configuration factory. Defaults to NULL.
   */
  public function __construct(
    TranslationInterface $translation,
    protected ?ConfigFactoryInterface $configFactory = NULL,
  ) {
    $this->setStringTranslation($translation);

    if ($configFactory === NULL) {
      @trigger_error('Calling ' . __CLASS__ . ' constructor with the $configFactory argument is deprecated in recaptcha_preloader:2.1.0 and is removed recaptcha_preloader:3.0.0. See https://www.drupal.org/node/3373502', E_USER_DEPRECATED);

      $this->configFactory = \Drupal::configFactory();
    }
  }

  /**
   * Implements hook_form_FORM_ID_alter().
   */
  public function __invoke(
    array &$form,
    FormStateInterface $form_state,
    string $form_id,
  ): void {
    $form['widget']['recaptcha_preloader'] = [
      '#type' => 'details',
      '#title' => $this->t('Preloader'),
      '#open' => TRUE,
    ];

    $config = $this->configFactory->get('recaptcha_preloader.settings');

    $form['widget']['recaptcha_preloader']['recaptcha_preloader_status'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable'),
      '#description' => $this->t('Disable submit form elements and show the message when reCAPTCHA is loading.'),
      '#default_value' => $config->get('status'),
    ];

    $form['widget']['recaptcha_preloader']['recaptcha_preloader_message'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Message'),
      '#description' => $this->t('Special text on the reCAPTCHA place while reCAPTCHA is loading.'),
      '#default_value' => $config->get('message'),
      '#states' => array_fill_keys(['enabled', 'required'], [
        ':input[name="recaptcha_preloader_status"]' => [
          'checked' => TRUE,
        ],
      ]),
    ];

    $form['#submit'][] = [$this, 'submit'];
  }

  /**
   * Form submission handler for recaptcha_admin_settings().
   *
   * @param array $form
   *   Form array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current form state.
   *
   * @deprecated in recaptcha_preloader:2.1.0 and is removed from
   *   recaptcha_preloader:3.0.0. There is no replacement.
   *
   * @see https://www.drupal.org/node/3373502
   */
  public function submit(array $form, FormStateInterface $form_state): void {
    @trigger_error(__METHOD__ . '() is deprecated in recaptcha_preloader:2.1.0 and is removed from recaptcha_preloader:3.0.0. There is no replacement. See https://www.drupal.org/node/3373502', E_USER_DEPRECATED);

    $this->configFactory->getEditable('recaptcha_preloader.settings')
      ->set('status', (bool) $form_state->getValue('recaptcha_preloader_status'))
      ->set('message', $form_state->getValue('recaptcha_preloader_message'))
      ->save();
  }

}
