<?php

namespace Drupal\recaptcha_preloader\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\recaptcha_preloader\Service\RecaptchaPreloaderHelperInterface;

/**
 * Implements hook_form_alter().
 */
#[Hook('form_alter')]
class RecaptchaPreloaderFormAlterHook {

  /**
   * RecaptchaPreloaderFormAlterHook constructor.
   *
   * @param \Drupal\recaptcha_preloader\Service\RecaptchaPreloaderHelperInterface $helper
   *   The helper.
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The configuration factory.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   The entity type manager.
   */
  public function __construct(
    protected RecaptchaPreloaderHelperInterface $helper,
    protected ConfigFactoryInterface $configFactory,
    protected EntityTypeManagerInterface $entityTypeManager,
  ) {}

  /**
   * Implements hook_form_alter().
   */
  public function __invoke(
    array &$form,
    FormStateInterface $form_state,
    string $form_id,
  ): void {
    if ($form_state->getUserInput() || !$this->helper->isAvailable()) {
      return;
    }

    $types = ['recaptcha/reCAPTCHA'];

    $default = $this->configFactory->get('captcha.settings')
      ->get('default_challenge');

    if ($default === $types[0]) {
      $types[] = 'default';
    }

    $query = $this->entityTypeManager->getStorage('captcha_point')->getQuery();

    $entities = $query
      ->condition('status', TRUE)
      ->condition(
        $query->orConditionGroup()
          ->condition('label', $form_id)
          ->condition('formId', $form_id),
      )
      ->condition('captchaType', $types, 'IN')
      ->count()
      ->accessCheck()
      ->execute();

    if ($entities) {
      $this->helper->search($form);
    }
  }

}
