<?php

namespace Drupal\recaptcha_preloader\Hook;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslationInterface;

/**
 * Implements hook_form_FORM_ID_alter().
 */
#[Hook('form_recaptcha_admin_settings_alter')]
class RecaptchaPreloaderFormRecaptchaAdminSettingsAlterHook {

  use StringTranslationTrait;

  /**
   * RecaptchaPreloaderFormRecaptchaAdminSettingsAlterHook constructor.
   *
   * @param \Drupal\Core\StringTranslation\TranslationInterface $translation
   *   The string translation.
   */
  public function __construct(TranslationInterface $translation) {
    $this->setStringTranslation($translation);
  }

  /**
   * Implements hook_form_FORM_ID_alter().
   */
  public function __invoke(
    array &$form,
    FormStateInterface $form_state,
    string $form_id,
  ): void {
    $form['widget']['recaptcha_preloader'] = [
      '#type' => 'details',
      '#title' => $this->t('Preloader'),
      '#open' => TRUE,
    ];

    $form['widget']['recaptcha_preloader']['recaptcha_preloader_status'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable'),
      '#description' => $this->t('Disable submit form elements and show the message when reCAPTCHA is loading.'),
      '#config_target' => 'recaptcha_preloader.settings:status',
    ];

    $form['widget']['recaptcha_preloader']['recaptcha_preloader_message'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Message'),
      '#description' => $this->t('Special text on the reCAPTCHA place while reCAPTCHA is loading.'),
      '#config_target' => 'recaptcha_preloader.settings:message',
      '#states' => array_fill_keys(['enabled', 'required'], [
        ':input[name="recaptcha_preloader_status"]' => [
          'checked' => TRUE,
        ],
      ]),
    ];
  }

}
