<?php

namespace Drupal\recaptcha_preloader\Hook;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Hook\Attribute\Hook;

/**
 * Implements hook_form_FORM_ID_alter().
 */
#[Hook('form_system_modules_alter')]
class RecaptchaPreloaderFormSystemModulesAlterHook {

  /**
   * Implements hook_form_FORM_ID_alter().
   */
  public function __invoke(
    array &$form,
    FormStateInterface $form_state,
    string $form_id,
  ): void {
    $form['modules']['Spam control']['recaptcha_preloader']['links']['configure']['#options']['fragment'] = 'edit-recaptcha-preloader';
  }

}
