<?php

namespace Drupal\recaptcha_preloader\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslationInterface;

/**
 * Implements hook_help().
 */
#[Hook('help')]
class RecaptchaPreloaderHelpHook {

  use StringTranslationTrait;

  /**
   * RecaptchaPreloaderHelpHook constructor.
   *
   * @param \Drupal\Core\StringTranslation\TranslationInterface $translation
   *   The string translation.
   */
  public function __construct(TranslationInterface $translation) {
    $this->setStringTranslation($translation);
  }

  /**
   * Implements hook_help().
   */
  public function __invoke(
    string $route_name,
    RouteMatchInterface $route_match,
  ): string {
    return match ($route_name) {
      'help.page.recaptcha_preloader' => <<<HTML
<h3>{$this->t('About')}</h3>
<p>{$this->t('Provides a preloader for Google reCAPTCHA v2 Checkbox.')}</p>
<p>{$this->t('In some cases (for example, with a slow Internet connection), the visitor may mistakenly decide that the login page has already loaded enough. After pressing the button to log in to the site, this does not happen because the captcha element has not yet been displayed on the page. So, that the user does not have such a false feeling, this module provides the following solutions:')}</p>
<ol>
  <li>{$this->t('Along with the form, display an element that copies the appearance of the captcha, which does not have a checkbox, but contains a message that warns that the captcha is in the process of loading.')}</li>
  <li>{$this->t('The site login button is initially inactive.')}</li>
  <li>{$this->t('Once the captcha is loaded, it replaces the stub element and the button becomes clickable.')}</li>
</ol>
HTML,
      default => '',
    };
  }

}
