# Recipe Code Installer

Recipe Code Installer enables Drupal Recipes to bundle custom modules that get installed directly into your project's codebase. This module bridges the gap between Drupal's configuration-focused Recipe system and the need for custom functionality.

## Overview

Recipe Code Installer **solves a fundamental limitation of Drupal Recipes \- their inability to contain custom code**. While Recipes excel at installing modules and applying configuration, many real-world solutions require custom code that doesn't warrant a separate module on Drupal.org.

This module **allows Recipe creators to include a custom module within their Recipe** that gets extracted and installed as a proper Drupal module when the Recipe is applied.

## Requirements

- Drupal 10.3 or higher
- Recipe API (included in Drupal core 10.3+)

## Installation

```shell
composer require drupal/recipe_code_installer && drush en recipe_code_installer
```

## How it works

Recipe Code Installer runs as the last stage of Recipe installation. The process works as follows:

1. When a Recipe is applied, Recipe Code Installer **checks for the presence of a `code` subdirectory** within the Recipe
2. If custom module code is detected, it **extracts this code** and **moves it to your project's custom module directory**
3. It then **installs the module by calling Drupal's module install function**

**The module listens for the** `\Drupal\Core\Recipe\RecipeAppliedEvent` **event**, which is fired when a Recipe is applied (not when it's installed via Composer). **This makes Recipe Code Installer fully compatible with the [Recipe Unpack Composer plugin](https://www.drupal.org/node/3522189)**, as it operates at a different stage in the Recipe lifecycle.

## Recipe structure example

```
enhanced_event_recipe/
├── code/                                 # Custom module code to be installed
│   ├── enhanced_event_recipe.info.yml
│   ├── enhanced_event_recipe.module
│   ├── enhanced_event_recipe.services.yml
│   └── src/
│       ├── PricingCalculator.php
│       └── Plugin/
│           └── Validation/
│               └── EventCapacityConstraint.php
│       └── ...
├── config/                               # Standard Recipe configuration
│   ├── node.type.event.yml
│   └── ...
└── recipe.yml                            # Standard Recipe definition
```

## Development Mode

Recipe Code Installer includes a development mode that's particularly helpful when developing Recipes with bundled code. When enabled, instead of copying the bundled code to the custom modules folder, the code gets symlinked. This creates a direct connection between the Recipe's code directory and the installed module, allowing changes to the bundled module to be immediately reflected without needing to reapply the Recipe.

You can enable development mode modifying the services.local.yml or a custom services file that is loaded at container build:

```yaml
parameters:
  recipe_code_installer.dev_mode: true
```

**Clear container cache (e.g., by executing `drush cr`) after this change.**

This feature is particularly useful for:

- Iterative development of Recipe-bundled modules
- Testing Recipe code changes without repeatedly applying the Recipe
- Debugging bundled module install hooks in a live environment

**Note that development mode should only be used during Recipe development and not in production environments.**

## Learn more about Recipe Code Installer

Want to understand the benefits of Recipe Code Installer for both Recipe creators and adopters? Curious about how it can streamline your Drupal development workflow?

**Visit our blog to read our comprehensive article: ["Recipe Code Installer: Bridging the gap between configuration and functionality"](https://pronovix.com/node/3748)** where we explore the problems it solves, practical use cases, and best practices for implementation.  