<?php

declare(strict_types = 1);

/**
 * Copyright (C) 2025 PRONOVIX GROUP.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 */

namespace Drupal\recipe_code_installer\Application\Port;

/**
 * Defines an interface for resolvers of the custom modules installation path.
 *
 * @internal This interface is not part of the module's public programming API.
 */
interface CustomModulesPathResolverInterface {

  /**
   * Retrieves the installation path for custom modules.
   *
   * @return string
   *   The installation path for custom modules.
   *
   * @throws \Drupal\recipe_code_installer\Application\Port\Exception\UnableToResolveCustomModulesInstallationPathException
   *   Thrown when the custom modules installation path could not be resolved.
   */
  public function getCustomModulesInstallPath(): string;

}
