# Drupal Recipe Installer Kit
If you thought the Drupal CMS installer was really slick, you might have wondered how to adapt it for your own nefarious purposes.

This package is a toolkit to create standalone install profiles that work the same way the Drupal CMS installer does -- installing Drupal by applying a bunch of recipes. But you can easily customize the stuff that really matters:
* Which recipes are shown to users at the beginning
* Which recipes are always applied
* Where users should be redirected afterwards
* How the installer looks and feels
* Which annoying post-install messages to hide

This is for developers who want a better, recipe-based installer experience, but don't want to write a pile of complicated PHP code to bend the Drupal installer to their will.

The Drupal CMS installer is built on top of this toolkit, but install profiles generated by this package don't depend on Drupal CMS; they'll work with any flavor of Drupal.

## How to use
1. Require this package into your project: `composer require drupal/recipe_installer_kit`
2. Use Drush to generate a stub install profile: `drush generate recipe-kit:installer --destination=profiles/SOME_MACHINE_NAME`
3. Go to the profile's directory and customize the `SOME_MACHINE_NAME.info.yml` file to your liking.

To change the look and feel, create a new theme -- just a regular old theme -- in a subdirectory of the profile, and add this to the profile's info file:
```yaml
distribution:
  install:
    theme: MACHINE_NAME_OF_THEME
 ```
For an example, see [Drupal CMS's project template](https://git.drupalcode.org/project/cms/-/tree/1.x/web/profiles/drupal_cms_installer?ref_type=heads).

Note that you could use any theme which is available in the code base; it doesn't have to live inside the install profile. But if you're going to create a custom theme _for the installer_, it sorta makes sense to bundle that with the profile, don't you think?
