# Recipe UI Module

A Drupal module that provides an admin interface to list and apply Drupal recipes.

## Features

- **Recipe Discovery**: Automatically discovers recipes in `/recipes` and `/core/recipes` directories
- **Admin Interface**: Provides a user-friendly admin page to view all available recipes
- **Recipe Application**: Apply recipes directly from the admin interface
- **Batch Support**: Apply recipes using Drupal's batch system for long-running operations
- **Recipe Information**: Display recipe name, description, type, and path

## Installation

1. Place the module in `web/modules/custom/recipe_ui/`
2. Enable the module via the admin interface or Drush:
   ```bash
   drush en recipe_ui
   ```

## Usage

1. Navigate to **Administration > Configuration > Development > Recipe UI**
2. Select a recipe from the list
3. Choose one of the following options:
   - **Apply Selected Recipe**: Applies the recipe immediately
   - **Apply Selected Recipe (Batch)**: Applies the recipe using Drupal's batch system
   - **Refresh Recipe List**: Reloads the recipe list

## Requirements

- Drupal 10.2+ or Drupal 11+
- Recipes must be placed in either:
  - `/recipes/` directory (for custom recipes)
  - `/core/recipes/` directory (for core recipes)

## Permissions

- **Administer site configuration**: Required to access the Recipe UI admin page

## Recipe Structure

Recipes must follow the standard Drupal recipe structure:
```
recipe_name/
├── recipe.yml
├── config/
└── content/
```

## Troubleshooting

- Check the Drupal logs if recipe application fails
- Ensure recipes are properly structured with valid `recipe.yml` files
- Verify file permissions for recipe directories
- Use the batch option for complex recipes that may take time to apply

## API

The module provides a `RecipeManager` service that can be used programmatically:

```php
$recipe_manager = \Drupal::service('recipe_ui.recipe_manager');

// Discover all recipes
$recipes = $recipe_manager->discoverRecipes();

// Apply a recipe
$success = $recipe_manager->applyRecipe('/path/to/recipe');

// Apply a recipe using batch
$success = $recipe_manager->applyRecipeBatch('/path/to/recipe');
```
