<?php

namespace Drupal\Tests\recurly_hosted\Functional;

use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\recurly\Traits\RecurlyTestTrait;

/**
 * Tests recurly hosted pages settings form.
 *
 * @group recurly
 */
class SettingsFormTest extends BrowserTestBase {

  use RecurlyTestTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['recurly', 'recurly_hosted'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->config('recurly.settings')
      ->set('recurly_entity_type', 'user')
      ->save();

    $this->rebuildRecurlyEntityRouting();
  }

  /**
   * Test the settings page.
   */
  public function testAnonymousUpdateBillingAccess() {
    $this->drupalGet('/user/1/subscription/billing');
    $this->assertSession()->statusCodeEquals(403);
  }

}
