<?php

namespace Drupal\recurlyjs\Event;

use Drupal\Core\Entity\EntityInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Recurly subscription alter event.
 */
class SubscriptionAlter extends Event {

  /**
   * The Recurly subscription data that will be used to create the subscription.
   *
   * @var array
   */
  protected array $subscription;

  /**
   * The entity the subscription is attached to.
   *
   * @var \Drupal\Core\Entity\EntityInterface
   */
  protected EntityInterface $entity;

  /**
   * Builds a Recurly subscription event.
   *
   * @param array $subscription
   *   The Recurly subscription data.
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity the subscription is attached to.
   */
  public function __construct(array $subscription, EntityInterface $entity) {
    $this->subscription = $subscription;
    $this->entity = $entity;
  }

  /**
   * Gets the subscription acted upon.
   *
   * @return array
   *   The Recurly subscription.
   */
  public function getSubscription(): array {
    return $this->subscription;
  }

  /**
   * Updates the subscription.
   *
   * @param array $subscription
   *   The Recurly subscription data.
   */
  public function updateSubscription(array $subscription): void {
    $this->subscription = $subscription;
  }

  /**
   * Gets the entity associated with the subscription.
   *
   * @return \Drupal\Core\Entity\EntityInterface
   *   The entity associated with the subscription.
   */
  public function getEntity(): EntityInterface {
    return $this->entity;
  }

}
