<?php

namespace Drupal\recurlyjs\Event;

use Drupal\Core\Entity\EntityInterface;
use Recurly\Resources\Subscription;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Recurly subscription created event.
 */
class SubscriptionCreated extends Event {
  /**
   * The Recurly subscription.
   *
   * @var \Recurly\Resources\Subscription
   */
  protected Subscription $subscription;

  /**
   * The entity the subscription is attached to.
   *
   * @var \Drupal\Core\Entity\EntityInterface
   */
  protected EntityInterface $entity;

  /**
   * Builds a Recurly subscription event.
   *
   * @param \Recurly\Resources\Subscription $subscription
   *   The Recurly subscription.
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity the subscription is attached to.
   */
  public function __construct(Subscription $subscription, EntityInterface $entity) {
    $this->subscription = $subscription;
    $this->entity = $entity;
  }

  /**
   * Gets the subscription acted upon.
   *
   * @return \Recurly\Resources\Subscription
   *   The Recurly subscription.
   */
  public function getSubscription(): Subscription {
    return $this->subscription;
  }

  /**
   * Updates the subscription.
   *
   * @param \Recurly\Resources\Subscription $subscription
   *   The Recurly subscription.
   */
  public function updateSubscription(Subscription $subscription): void {
    $this->subscription = $subscription;
  }

  /**
   * Gets the entity associated with the subscription.
   *
   * @return \Drupal\Core\Entity\EntityInterface
   *   The entity associated with the subscription.
   */
  public function getEntity(): EntityInterface {
    return $this->entity;
  }

}
