<?php

namespace Drupal\Tests\recurlyjs\FunctionalJavascript;

use Drupal\FunctionalJavascriptTests\WebDriverTestBase;
use Drupal\Tests\recurly\Traits\RecurlyTestTrait;

/**
 * Base class for creating WebDriver tests for RecurlyJS.
 *
 * @group recurly
 */
abstract class RecurlyJsWebDriverTestBase extends WebDriverTestBase {

  use RecurlyTestTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'block',
    'field_test',
    'node',
    'recurly',
    'recurlyjs',
    'recurly_test_client',
    'user',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp() : void {
    parent::setUp();

    $this->drupalPlaceBlock('local_tasks_block');
    $this->drupalPlaceBlock('system_messages_block');

    // Associate Recurly subscriptions with user entities and enable the
    // "silver" mock plan.
    $this->config('recurly.settings')
      ->set('recurly_public_key', 'ASDF-1234')
      ->set('recurly_private_api_key', 'ASDF-1234')
      ->set('recurly_subdomain', 'recurly-drupal-test')
      ->set('recurly_entity_type', 'user')
      ->set('recurly_subscription_plans', [
        'silver' => [
          'status' => 1,
          'weight' => 0,
        ],
      ])
      ->save();

    $this->rebuildRecurlyEntityRouting();
  }

}
