<?php

namespace Drupal\recurly_test_client;

use Drupal\recurly\RecurlyClientFactory;

/**
 * Service decorator for Drupal\recurly\RecurlyClientFactory.
 *
 * Initializes and returns an instance of
 * Drupal\recurly_test_client\RecurlyMockClient instead of \Recurly\Client.
 */
class RecurlyMockClientFactory extends RecurlyClientFactory {

  /**
   * Return a mock Recurly API client.
   *
   * @return bool|\Drupal\recurly_test_client\RecurlyV3MockClient|\Recurly\Client
   *   Recurly API client that returns canned responses.
   */
  public function getClientFromSettings(?array $account_settings = NULL) {
    return new RecurlyV3MockClient('api-key-123-asd');
  }

}
