<?php

namespace Drupal\Tests\recurly\Functional;

use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\recurly\Traits\RecurlyTestTrait;
use Drupal\recurly_test_client\RecurlyV3MockClient;

/**
 * Base class with utilities for functional recurly tests.
 *
 * @group recurly
 */
abstract class RecurlyBrowserTestBase extends BrowserTestBase {

  use RecurlyTestTrait;

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'block',
    'field_test',
    'node',
    'recurly',
    'recurly_test_client',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp() : void {
    parent::setUp();

    // Associate Recurly subscriptions with user entities and enable the
    // "silver" mock plan.
    $this->config('recurly.settings')
      ->set('recurly_client_logging_enabled', TRUE)
      ->set('recurly_entity_type', 'user')
      ->set('recurly_subscription_plans', [
        'silver' => [
          'status' => 1,
          'weight' => 0,
        ],
      ])
      ->save();

    $this->rebuildRecurlyEntityRouting();
  }

  /**
   * Helper method to add mock responses shared by most test methods.
   */
  protected function addSharedResponses($account) {
    $recurly_account_code = 'user-' . $account->id();

    // Invoices.
    $invoice_list = [
      'object' => 'list',
      'has_more' => FALSE,
      'next' => NULL,
      'data' => [],
    ];
    RecurlyV3MockClient::addResponse('GET', '/accounts/' . $recurly_account_code . '/invoices', json_encode($invoice_list));
    RecurlyV3MockClient::addResponse('GET', '/accounts/code-' . $recurly_account_code . '/invoices', json_encode($invoice_list));

    // Coupons for listActiveCouponRedemptions().
    $coupon_list = [
      'object' => 'list',
      'has_more' => FALSE,
      'next' => NULL,
      'data' => [],
    ];
    RecurlyV3MockClient::addResponse('GET', '/accounts/' . $recurly_account_code . '/coupon_redemptions/active', json_encode($coupon_list));
    RecurlyV3MockClient::addResponse('GET', '/accounts/code-' . $recurly_account_code . '/coupon_redemptions/active', json_encode($coupon_list));
  }

}
