<?php

namespace Drupal\Tests\recurly\Functional;

use Drupal\recurly_test_client\RecurlyV3MockClient;

/**
 * Tests for RecurlyRedeemCouponFormTest.
 *
 * @group recurly
 */
class RecurlyRedeemCouponFormTest extends RecurlyBrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected function setUp() : void {
    parent::setUp();
    $this->drupalPlaceBlock('local_tasks_block');
    $this->drupalPlaceBlock('system_messages_block');

    RecurlyV3MockClient::clear();
  }

  /**
   * Test access to coupon redemption form based on module configuration.
   *
   * @covers \Drupal\recurly\Access\RecurlyAccessCoupon
   */
  public function testAccessControl() {
    $account = $this->createUserWithSubscription();
    $this->drupalLogin($account);
    $this->addSharedResponses($account);

    $this->config('recurly.settings')
      ->set('recurly_coupon_page', 0)
      ->save();

    $this->drupalGet($account->toUrl('recurly-coupon'));
    $this->assertSession()->statusCodeEquals(403);

    $this->config('recurly.settings')
      ->set('recurly_coupon_page', 1)
      ->save();

    $this->drupalGet($account->toUrl('recurly-coupon'));
    $this->assertSession()->statusCodeEquals(200);
  }

}
