<?php

namespace Drupal\Tests\recurly\Unit;

use Drupal\Tests\UnitTestCase;
use Drupal\recurly\RecurlyUrlManager;

/**
 * Test the Recurly Url Manager.
 *
 * @coversDefaultClass \Drupal\recurly\RecurlyUrlManager
 * @group recurly
 */
class RecurlyUrlManagerTest extends UnitTestCase {

  /**
   * The url manager to be tested.
   *
   * @var \Drupal\recurly\RecurlyUrlManager
   */
  protected $recurlyUrlManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp() : void {
    parent::setUp();
    $config_factory = $this->getConfigFactoryStub(['recurly.settings' => ['verbose' => TRUE]]);

    $this->recurlyUrlManager = new RecurlyUrlManager($config_factory);
  }

  /**
   * Verify url is being generated correctly.
   *
   * @covers ::hostedUrl
   */
  public function testHostedUrl() {
    $hosted_url = $this->recurlyUrlManager->hostedUrl('configuration/currencies', 'sub-domain')->getUri();
    $this->assertEquals('https://sub-domain.recurly.com/configuration/currencies', $hosted_url);
  }

}
