<?php

namespace Drupal\recurly_commerce_api\Event;

use Symfony\Contracts\EventDispatcher\Event as SymfonyEvent;

/**
 * Recurly Commerce API Webhook Event.
 *
 * Provides the Recurly Commerce API Webhook Event.
 */
class RecurlyCommerceApiWebhookEvent extends SymfonyEvent {

  /**
   * Webhook event type.
   *
   * @var string
   */
  public $type;

  /**
   * Webhook event data.
   *
   * @var object
   */
  public $data;

  /**
   * Sets the default values for the event.
   *
   * @param string $type
   *   Webhook event type (e.g., 'new_subscription_notification').
   * @param object $data
   *   Webhook event data.
   */
  public function __construct(string $type, $data) {
    $this->type = $type;
    $this->data = $data;
  }

}
