<?php

namespace Drupal\recurly_commerce_api\EventSubscriber;

use Drupal\recurly_commerce_api\Event\RecurlyCommerceApiWebhookEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Recurly API Webhook Event Subscriber.
 *
 * Example subscriber that logs webhook events. Other modules should create
 * their own subscribers to handle specific webhook events.
 */
class RecurlyCommerceApiWebhookSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      'recurly_commerce_api.webhook' => 'onWebhook',
    ];
  }

  /**
   * React to webhook events.
   *
   * @param \Drupal\recurly_commerce_api\Event\RecurlyCommerceApiWebhookEvent $event
   *   The webhook event.
   */
  public function onWebhook(RecurlyCommerceApiWebhookEvent $event) {
    // Log all webhook events.
    \Drupal::logger('recurly_commerce_api')->info('Webhook event received: @type', [
      '@type' => $event->type,
    ]);

    // Example: React to specific event types.
    switch ($event->type) {
      case 'new_subscription_notification':
        // Handle new subscription.
        break;

      case 'updated_subscription_notification':
        // Handle subscription update.
        break;

      case 'canceled_subscription_notification':
      case 'expired_subscription_notification':
        // Handle subscription cancellation/expiration.
        break;
    }
  }

}
