<?php

declare(strict_types=1);

namespace Drupal\recurring_events_ical\Plugin\Field\FieldFormatter;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\link\Plugin\Field\FieldFormatter\LinkFormatter;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Plugin implementation of the 'event_ical_link' formatter.
 */
#[FieldFormatter(
  id: "event_ical_link",
  label: new TranslatableMarkup("Event iCalendar Link"),
  field_types: [
    "event_ical_link",
  ],
)]
class EventICalLinkFormatter extends LinkFormatter {

  public function __construct(
    $plugin_id,
    $plugin_definition,
    FieldDefinitionInterface $field_definition,
    array $settings,
    $label,
    $view_mode,
    array $third_party_settings,
    $path_validator,
    protected readonly ConfigFactoryInterface $configFactory,
  ) {
    parent::__construct($plugin_id, $plugin_definition, $field_definition, $settings, $label, $view_mode, $third_party_settings, $path_validator);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    /** @var \Drupal\Core\Path\PathValidatorInterface $pathValidator */
    $pathValidator = $container->get('path.validator');
    /** @var \Drupal\Core\Config\ConfigFactoryInterface $configFactory */
    $configFactory = $container->get('config.factory');
    return new static(
      $plugin_id,
      $plugin_definition,
      $configuration['field_definition'],
      $configuration['settings'],
      $configuration['label'],
      $configuration['view_mode'],
      $configuration['third_party_settings'],
      $pathValidator,
      $configFactory
    );
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $entity = $items->getEntity();
    $entityType = $entity->getEntityType()->id();
    $config = $this->configFactory->get("recurring_events.$entityType.config");
    $linkTitle = $config->get('ical_link_title') ?? $this->t('Download as iCal');
    foreach ($items as $item) {
      $item->title = $linkTitle;
    }
    return parent::viewElements($items, $langcode);
  }

}
