<?php

declare(strict_types=1);

namespace Drupal\recurring_events_ical\Plugin\Field\FieldType;

use Drupal\Core\Field\Attribute\FieldType;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\link\Plugin\Field\FieldType\LinkItem;

/**
 * Plugin implementation of the 'event_ical_link' field type.
 */
#[FieldType(
  id: "event_ical_link",
  label: new TranslatableMarkup("Event iCalendar Link"),
  description: new TranslatableMarkup("A link to an event's iCalendar download."),
  default_widget: "link_default",
  default_formatter: "event_ical_link",
  constraints: [
    "LinkType" => [],
    "LinkAccess" => [],
    "LinkExternalProtocols" => [],
    "LinkNotExistingInternal" => [],
  ]
)]
class EventICalLinkItem extends LinkItem {
  // No implementation; only exists to define the default formatter.
}
